/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractParameterization
implements Parameterization {
    private static final Logging LOG = Logging.getLogger(AbstractParameterization.class);
    List<ParameterException> errors = new ArrayList<ParameterException>();

    @Override
    public Collection<ParameterException> getErrors() {
        return this.errors;
    }

    @Override
    public void reportError(ParameterException e) {
        this.errors.add(e);
    }

    public synchronized void logAndClearReportedErrors() {
        for (ParameterException e : this.getErrors()) {
            if (LOG.isDebugging()) {
                LOG.warning(e.getMessage(), e);
                continue;
            }
            LOG.warning(e.getMessage());
        }
        this.clearErrors();
    }

    public synchronized void clearErrors() {
        this.errors = new ArrayList<ParameterException>();
    }

    public void failOnErrors() throws AbortException {
        int numerror = this.getErrors().size();
        if (numerror > 0) {
            this.logAndClearReportedErrors();
            throw new AbortException(numerror + " errors occurred during parameterization.");
        }
    }

    protected void finalize() throws Throwable {
        this.failOnErrors();
        super.finalize();
    }
}

