/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ListParameterization
extends AbstractParameterization {
    List<ParameterPair> parameters = new LinkedList<ParameterPair>();

    public ListParameterization() {
    }

    public ListParameterization(Collection<ParameterPair> dbParameters) {
        this();
        this.parameters = new LinkedList<ParameterPair>();
        for (ParameterPair pair : dbParameters) {
            if (pair.option instanceof OptionID) {
                this.addParameter((OptionID)pair.option, pair.value);
                continue;
            }
            if (pair.option instanceof String) {
                this.addParameter((String)pair.option, pair.value);
                continue;
            }
            throw new IllegalStateException("The option field must only store OptionID or Strings.");
        }
    }

    public ListParameterization addFlag(OptionID optionid) {
        this.parameters.add(new ParameterPair(optionid, "true"));
        return this;
    }

    public ListParameterization addFlag(String optionid) {
        this.parameters.add(new ParameterPair(optionid, "true"));
        return this;
    }

    public ListParameterization addParameter(OptionID optionid, Object value) {
        this.parameters.add(new ParameterPair(optionid, value));
        return this;
    }

    protected ListParameterization addParameter(ParameterPair pair) {
        this.parameters.add(pair);
        return this;
    }

    public ListParameterization addParameter(String optionid, Object value) {
        optionid = optionid.startsWith("-") ? optionid.substring("-".length()) : optionid;
        this.parameters.add(new ParameterPair(optionid, value));
        return this;
    }

    @Override
    public boolean setValueForOption(Parameter<?> opt) throws ParameterException {
        Iterator<ParameterPair> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            ParameterPair pair = iter.next();
            if (pair.option != opt.getOptionID() && (!(pair.option instanceof String) || !opt.getOptionID().getName().equals(pair.option))) continue;
            iter.remove();
            opt.setValue(pair.value);
            return true;
        }
        return false;
    }

    public List<ParameterPair> getRemainingParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasUnusedParameters() {
        return !this.parameters.isEmpty();
    }

    @Override
    public ListParameterization descend(Object option) {
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ParameterPair pair : this.parameters) {
            buf.append("-").append(pair.option.toString()).append(' ').append(pair.value.toString()).append(' ');
        }
        return buf.toString();
    }

    public ArrayList<String> serialize() {
        ArrayList<String> params = new ArrayList<String>();
        for (ParameterPair pair : this.parameters) {
            params.add("-" + pair.option.toString());
            if (pair.value instanceof String) {
                params.add((String)pair.value);
                continue;
            }
            if (pair.value instanceof Class) {
                params.add(((Class)pair.value).getCanonicalName());
                continue;
            }
            params.add(pair.value.toString());
        }
        return params;
    }

    protected static final class ParameterPair {
        public Object option;
        public Object value;

        public ParameterPair(Object key, Object value) {
            this.option = key;
            this.value = value;
        }

        public String toString() {
            return "-" + this.option.toString() + " " + this.value;
        }
    }
}

