/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SerializedParameterization
extends AbstractParameterization {
    public static final String OPTION_PREFIX = "-";
    LinkedList<String> parameters = new LinkedList();

    public SerializedParameterization() {
    }

    public SerializedParameterization(String[] args) {
        this();
        for (String arg : args) {
            this.parameters.add(arg);
        }
    }

    public SerializedParameterization(List<String> args) {
        this();
        this.parameters.addAll(args);
    }

    public List<String> getRemainingParameters() {
        return this.parameters;
    }

    @Override
    public boolean hasUnusedParameters() {
        return !this.parameters.isEmpty();
    }

    public void logUnusedParameters() {
        if (this.hasUnusedParameters()) {
            LoggingUtil.warning("The following parameters were not processed: " + this.parameters);
        }
    }

    @Override
    public boolean setValueForOption(Parameter<?> opt) throws ParameterException {
        Iterator piter = this.parameters.iterator();
        while (piter.hasNext()) {
            String cur = (String)piter.next();
            if (!cur.startsWith(OPTION_PREFIX) || !opt.getOptionID().getName().regionMatches(0, cur, 1, Math.max(opt.getOptionID().getName().length(), cur.length() - 1))) continue;
            piter.remove();
            if (opt instanceof Flag) {
                String set = "true";
                if (piter.hasNext()) {
                    String next = (String)piter.next();
                    if ("true".equals(next)) {
                        set = "true";
                        piter.remove();
                    } else if ("false".equals(next)) {
                        set = "false";
                        piter.remove();
                    } else if (!next.startsWith(OPTION_PREFIX)) {
                        throw new WrongParameterValueException(opt, next, "invalid value for a boolean flag.");
                    }
                }
                opt.setValue(set);
                return true;
            }
            if (!piter.hasNext()) {
                throw new UnspecifiedParameterException(opt);
            }
            opt.setValue(piter.next());
            piter.remove();
            return true;
        }
        return false;
    }
}

