/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrackParameters
implements Parameterization {
    Parameterization inner;
    List<TrackedParameter> options = new ArrayList<TrackedParameter>();
    Map<Object, Object> parents = new HashMap<Object, Object>();
    Map<Object, List<Object>> children = new HashMap<Object, List<Object>>();
    Object owner = null;

    public TrackParameters(Parameterization inner) {
        this.inner = inner;
    }

    public TrackParameters(Parameterization inner, Object owner) {
        this.inner = inner;
        this.owner = owner;
    }

    private TrackParameters(Parameterization inner, Object owner, List<TrackedParameter> options, Map<Object, Object> parents, Map<Object, List<Object>> children) {
        this.inner = inner.descend(owner);
        this.owner = owner;
        this.options = options;
        this.parents = parents;
        this.children = children;
    }

    @Override
    public Collection<ParameterException> getErrors() {
        return this.inner.getErrors();
    }

    @Override
    public boolean grab(Parameter<?> opt) {
        this.registerChild(opt);
        this.options.add(new TrackedParameter(this.owner, opt));
        return this.inner.grab(opt);
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.inner.hasUnusedParameters();
    }

    @Override
    public void reportError(ParameterException e) {
        this.inner.reportError(e);
    }

    @Override
    public boolean setValueForOption(Parameter<?> opt) throws ParameterException {
        this.registerChild(opt);
        this.options.add(new TrackedParameter(this.owner, opt));
        return this.inner.setValueForOption(opt);
    }

    public Collection<TrackedParameter> getAllParameters() {
        return this.options;
    }

    @Override
    public Parameterization descend(Object option) {
        this.registerChild(option);
        return new TrackParameters(this.inner, option, this.options, this.parents, this.children);
    }

    private void registerChild(Object opt) {
        if (opt == this.owner) {
            LoggingUtil.exception("Options shouldn't have themselves as parents!", new Throwable());
        }
        this.parents.put(opt, this.owner);
        List<Object> c = this.children.get(this.owner);
        if (c == null) {
            c = new ArrayList<Object>();
            this.children.put(this.owner, c);
        }
        if (!c.contains(opt)) {
            c.add(opt);
        }
    }

    public Object getParent(Object pos) {
        return this.parents.get(pos);
    }
}

