/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractParameter<THIS extends AbstractParameter<THIS, T>, T>
implements Parameter<T> {
    protected T defaultValue = null;
    private boolean defaultValueTaken = false;
    protected boolean optionalParameter = false;
    protected List<ParameterConstraint<? super T>> constraints;
    protected final OptionID optionid;
    protected String shortDescription;
    protected T givenValue = null;
    private T value;

    public AbstractParameter(OptionID optionID, T defaultValue) {
        this.optionid = optionID;
        this.shortDescription = optionID.getDescription();
        this.optionalParameter = true;
        this.defaultValue = defaultValue;
    }

    public AbstractParameter(OptionID optionID, boolean optional) {
        this.optionid = optionID;
        this.shortDescription = optionID.getDescription();
        this.optionalParameter = optional;
        this.defaultValue = null;
    }

    public AbstractParameter(OptionID optionID) {
        this(optionID, false);
    }

    public THIS setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        this.optionalParameter = true;
        return (THIS)this;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    @Override
    public boolean tryDefaultValue() throws UnspecifiedParameterException {
        if (this.hasDefaultValue()) {
            this.setValueInternal(this.defaultValue);
            this.defaultValueTaken = true;
            return true;
        }
        if (this.isOptional()) {
            return false;
        }
        throw new UnspecifiedParameterException(this);
    }

    public THIS setOptional(boolean opt) {
        this.optionalParameter = opt;
        return (THIS)this;
    }

    @Override
    public boolean isOptional() {
        return this.optionalParameter;
    }

    @Override
    public boolean tookDefaultValue() {
        return this.defaultValueTaken;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public StringBuilder describeValues(StringBuilder description) {
        return description;
    }

    protected boolean validate(T obj) throws ParameterException {
        if (this.constraints != null) {
            for (ParameterConstraint<T> cons : this.constraints) {
                cons.test(obj);
            }
        }
        return true;
    }

    @Override
    public OptionID getOptionID() {
        return this.optionid;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String description) {
        this.shortDescription = description;
    }

    @Override
    public void setValue(Object obj) throws ParameterException {
        T val;
        if (obj != null && this.validate(val = this.parseValue(obj))) {
            this.setValueInternal(val);
            return;
        }
        throw new InvalidParameterException("Value for option \"" + this.getOptionID().getName() + "\" did not validate: " + obj);
    }

    protected final void setValueInternal(T val) {
        this.givenValue = val;
        this.value = this.givenValue;
    }

    @Override
    public final T getValue() {
        if (this.value == null) {
            LoggingUtil.warning("Programming error: Parameter#getValue() called for unset parameter \"" + this.getOptionID().getName() + "\"", new Throwable());
        }
        return this.value;
    }

    @Override
    public final boolean isValid(Object obj) throws ParameterException {
        return obj != null && this.validate(this.parseValue(obj));
    }

    @Override
    public abstract String getSyntax();

    protected abstract T parseValue(Object var1) throws ParameterException;

    @Override
    public abstract String getValueAsString();

    @Override
    public String getDefaultValueAsString() {
        return this.getDefaultValue().toString();
    }

    public THIS addConstraint(ParameterConstraint<? super T> constraint) {
        List<ParameterConstraint<Object>> list;
        if (this.constraints != null) {
            list = this.constraints;
        } else {
            this.constraints = new ArrayList<ParameterConstraint<T>>(2);
            list = this.constraints;
        }
        list.add(constraint);
        return (THIS)this;
    }

    @Override
    public List<ParameterConstraint<? super T>> getConstraints() {
        return this.constraints != null ? Collections.unmodifiableList(this.constraints) : Collections.emptyList();
    }
}

