/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ClassInstantiationException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.List;

public class ClassParameter<C>
extends AbstractParameter<ClassParameter<C>, Class<? extends C>> {
    private static final Logging LOG = Logging.getLogger(ClassParameter.class);
    protected Class<C> restrictionClass;

    public ClassParameter(OptionID optionID, Class<?> restrictionClass, Class<?> defaultValue) {
        super(optionID, defaultValue);
        this.restrictionClass = restrictionClass;
        if (restrictionClass == null) {
            LOG.warning("Restriction class 'null' for parameter '" + optionID + "'", new Throwable());
        }
    }

    public ClassParameter(OptionID optionID, Class<?> restrictionClass, boolean optional) {
        super(optionID, optional);
        this.restrictionClass = restrictionClass;
        if (restrictionClass == null) {
            LOG.warning("Restriction class 'null' for parameter '" + optionID + "'", new Throwable());
        }
    }

    public ClassParameter(OptionID optionID, Class<?> restrictionClass) {
        this(optionID, restrictionClass, false);
    }

    @Override
    protected Class<? extends C> parseValue(Object obj) throws ParameterException {
        Class<C> clz;
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String && (clz = ELKIServiceRegistry.findImplementation(this.restrictionClass, (String)obj)) != null) {
            return clz;
        }
        throw new WrongParameterValueException(this, obj.toString(), "Class not found for given value. Must be a subclass / implementation of " + this.restrictionClass.getName());
    }

    @Override
    public boolean validate(Class<? extends C> obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (!this.restrictionClass.isAssignableFrom(obj)) {
            throw new WrongParameterValueException(this, obj.getName(), "Given class not a subclass / implementation of " + this.restrictionClass.getName());
        }
        return super.validate(obj);
    }

    @Override
    public String getSyntax() {
        return "<class>";
    }

    @Override
    public StringBuilder describeValues(StringBuilder info) {
        if (this.restrictionClass == null || this.restrictionClass == Object.class) {
            return info;
        }
        info.append(this.restrictionClass.isInterface() ? "Implementing " : "Extending ").append(this.restrictionClass.getName()).append(FormatUtil.NEWLINE);
        List<Class<?>> known = this.getKnownImplementations();
        if (!known.isEmpty()) {
            for (Class<?> c : known) {
                info.append("->").append(FormatUtil.NONBREAKING_SPACE).append(ClassParameter.canonicalClassName(c, this.getRestrictionClass())).append(FormatUtil.NEWLINE);
            }
        }
        return info;
    }

    @Override
    public String getValueAsString() {
        return ClassParameter.canonicalClassName((Class)this.getValue(), this.getRestrictionClass());
    }

    @Override
    public String getDefaultValueAsString() {
        return ClassParameter.canonicalClassName((Class)this.getDefaultValue(), this.getRestrictionClass());
    }

    public static String canonicalClassName(Class<?> c, Package pkg) {
        String name = c.getName();
        if (pkg != null) {
            String pkgname = pkg.getName();
            if (name.length() > pkgname.length() && name.startsWith(pkgname) && name.charAt(pkgname.length()) == '.') {
                name = name.substring(pkgname.length() + 1);
            }
        }
        if (name.endsWith("$Factory")) {
            name = name.substring(0, name.length() - "$Factory".length());
        }
        return name;
    }

    public static String canonicalClassName(Class<?> c, Class<?> parent) {
        return ClassParameter.canonicalClassName(c, parent == null ? null : parent.getPackage());
    }

    public C instantiateClass(Parameterization config) {
        if (this.getValue() == null) {
            config.reportError(new UnspecifiedParameterException(this));
            return null;
        }
        try {
            config = config.descend(this);
            return ClassGenericsUtil.tryInstantiate(this.restrictionClass, (Class)this.getValue(), config);
        }
        catch (ClassInstantiationException e) {
            config.reportError(new WrongParameterValueException(this, ((Class)this.getValue()).getCanonicalName(), "Error instantiating class.", e));
            return null;
        }
    }

    public Class<C> getRestrictionClass() {
        return this.restrictionClass;
    }

    public List<Class<?>> getKnownImplementations() {
        return ELKIServiceRegistry.findAllImplementations(this.getRestrictionClass());
    }
}

