/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class DoubleArrayListParameter
extends ListParameter<DoubleArrayListParameter, List<double[]>> {
    public DoubleArrayListParameter(OptionID optionID, ParameterConstraint<List<double[]>> constraint, List<double[]> defaultValue) {
        super(optionID, defaultValue);
        this.addConstraint(constraint);
    }

    public DoubleArrayListParameter(OptionID optionID, ParameterConstraint<List<double[]>> constraint, boolean optional) {
        super(optionID, optional);
        this.addConstraint(constraint);
    }

    public DoubleArrayListParameter(OptionID optionID, ParameterConstraint<List<double[]>> constraint) {
        super(optionID);
        this.addConstraint(constraint);
    }

    public DoubleArrayListParameter(OptionID optionID, List<double[]> defaultValue) {
        super(optionID, defaultValue);
    }

    public DoubleArrayListParameter(OptionID optionID, boolean optional) {
        super(optionID, optional);
    }

    public DoubleArrayListParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        StringBuilder buf = new StringBuilder();
        List val = (List)this.getValue();
        Iterator valiter = val.iterator();
        while (valiter.hasNext()) {
            buf.append(FormatUtil.format((double[])valiter.next(), ","));
            if (!valiter.hasNext()) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        StringBuilder buf = new StringBuilder();
        List val = (List)this.getDefaultValue();
        Iterator valiter = val.iterator();
        while (valiter.hasNext()) {
            buf.append(FormatUtil.format((double[])valiter.next(), ","));
            if (!valiter.hasNext()) continue;
            buf.append(":");
        }
        return buf.toString();
    }

    @Override
    protected List<double[]> parseValue(Object obj) throws ParameterException {
        try {
            List l = (List)List.class.cast(obj);
            for (Object o : l) {
                if (o instanceof double[]) continue;
                throw new WrongParameterValueException("Wrong parameter format for parameter \"" + this.getOptionID().getName() + "\". Given list contains objects of different type!");
            }
            return l;
        }
        catch (ClassCastException l) {
            if (obj instanceof String) {
                String[] vectors = VECTOR_SPLIT.split((String)obj);
                if (vectors.length == 0) {
                    throw new WrongParameterValueException("Wrong parameter format! Given list of vectors for parameter \"" + this.getOptionID().getName() + "\" is empty!");
                }
                ArrayList<double[]> vecs = new ArrayList<double[]>();
                double[] buf = new double[11];
                int used = 0;
                for (String vector : vectors) {
                    String[] coordinates;
                    used = 0;
                    for (String coordinate : coordinates = SPLIT.split(vector)) {
                        try {
                            if (used == buf.length) {
                                buf = Arrays.copyOf(buf, buf.length << 1);
                            }
                            buf[used++] = ParseUtil.parseDouble(coordinate);
                        }
                        catch (NumberFormatException e) {
                            throw new WrongParameterValueException("Wrong parameter format! Coordinates of vector \"" + vector + "\" are not valid!");
                        }
                    }
                    vecs.add(Arrays.copyOf(buf, used));
                }
                return vecs;
            }
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a list of double values!");
        }
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public String getSyntax() {
        return "<double_11,...,double_1n:...:double_m1,...,double_mn>";
    }
}

