/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;

public class DoubleListParameter
extends ListParameter<DoubleListParameter, double[]> {
    public DoubleListParameter(OptionID optionID, boolean optional) {
        super(optionID, optional);
    }

    public DoubleListParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return FormatUtil.format((double[])this.getValue(), ",");
    }

    @Override
    public String getDefaultValueAsString() {
        return FormatUtil.format((double[])this.getDefaultValue(), ",");
    }

    @Override
    protected double[] parseValue(Object obj) throws ParameterException {
        if (obj instanceof double[]) {
            return (double[])double[].class.cast(obj);
        }
        if (obj instanceof String) {
            String[] values = SPLIT.split((String)obj);
            double[] doubleValue = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                doubleValue[i] = ParseUtil.parseDouble(values[i]);
            }
            return doubleValue;
        }
        if (obj instanceof Double) {
            return new double[]{(Double)obj};
        }
        throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a list of Double values!");
    }

    @Override
    public int size() {
        return ((double[])this.getValue()).length;
    }

    @Override
    public String getSyntax() {
        return "<double_1,...,double_n>";
    }
}

