/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.ArrayList;
import java.util.Collection;

public class EnumParameter<E extends Enum<E>>
extends AbstractParameter<EnumParameter<E>, E> {
    protected Class<E> enumClass;

    public EnumParameter(OptionID optionID, Class<E> enumClass, E defaultValue) {
        super(optionID, defaultValue);
        this.enumClass = enumClass;
    }

    public EnumParameter(OptionID optionID, Class<E> enumClass, boolean optional) {
        super(optionID, optional);
        this.enumClass = enumClass;
    }

    public EnumParameter(OptionID optionID, Class<E> enumClass) {
        super(optionID);
        this.enumClass = enumClass;
    }

    @Override
    public String getSyntax() {
        return "<" + this.joinEnumNames(" | ") + ">";
    }

    @Override
    protected E parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (this.enumClass.isInstance(obj)) {
            return (E)((Enum)this.enumClass.cast(obj));
        }
        if (obj instanceof String) {
            try {
                return Enum.valueOf(this.enumClass, (String)obj);
            }
            catch (IllegalArgumentException ex) {
                throw new WrongParameterValueException("Enum parameter " + this.getOptionID().getName() + " is invalid (must be one of [" + this.joinEnumNames(", ") + "].");
            }
        }
        throw new WrongParameterValueException("Enum parameter " + this.getOptionID().getName() + " is not given as a string.");
    }

    @Override
    public String getValueAsString() {
        return ((Enum)this.getValue()).name();
    }

    @Override
    public StringBuilder describeValues(StringBuilder buf) {
        buf.append("One of:").append(FormatUtil.NEWLINE);
        for (String s : this.getPossibleValues()) {
            buf.append("->").append(FormatUtil.NONBREAKING_SPACE).append(s).append(FormatUtil.NEWLINE);
        }
        return buf;
    }

    public Collection<String> getPossibleValues() {
        Enum[] enums = (Enum[])this.enumClass.getEnumConstants();
        ArrayList<String> values = new ArrayList<String>(enums.length);
        for (Enum t : enums) {
            values.add(t.name());
        }
        return values;
    }

    private String joinEnumNames(String separator) {
        Enum[] enumTypes = (Enum[])this.enumClass.getEnumConstants();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < enumTypes.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(enumTypes[i].name());
        }
        return sb.toString();
    }
}

