/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileListParameter
extends ListParameter<FileListParameter, List<File>> {
    private FilesType filesType;

    public FileListParameter(OptionID optionID, FilesType filesType) {
        super(optionID);
        this.filesType = filesType;
    }

    @Override
    public String getValueAsString() {
        StringBuilder buf = new StringBuilder();
        List val = (List)this.getValue();
        Iterator veciter = val.iterator();
        while (veciter.hasNext()) {
            buf.append(veciter.next());
            if (!veciter.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        StringBuilder buf = new StringBuilder();
        List val = (List)this.getDefaultValue();
        Iterator veciter = val.iterator();
        while (veciter.hasNext()) {
            buf.append(veciter.next());
            if (!veciter.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    @Override
    protected List<File> parseValue(Object obj) throws ParameterException {
        try {
            List l = (List)List.class.cast(obj);
            for (Object o : l) {
                if (o instanceof File) continue;
                throw new WrongParameterValueException(this, obj.toString(), "expected a List<File> or a String.");
            }
            return l;
        }
        catch (ClassCastException l) {
            if (obj instanceof String) {
                String[] values = SPLIT.split((String)obj);
                ArrayList<File> fileValue = new ArrayList<File>(values.length);
                for (String val : values) {
                    fileValue.add(new File(val));
                }
                return fileValue;
            }
            throw new WrongParameterValueException(this, obj.toString(), "expected a String containing file names.");
        }
    }

    @Override
    protected boolean validate(List<File> obj) throws ParameterException {
        if (!super.validate(obj)) {
            return false;
        }
        if (this.filesType.equals((Object)FilesType.INPUT_FILES)) {
            for (File file : obj) {
                try {
                    if (file.exists()) continue;
                    throw new WrongParameterValueException(this, this.getValueAsString(), "File \"" + file.getPath() + "\" does not exist.");
                }
                catch (SecurityException e) {
                    throw new WrongParameterValueException(this, this.getValueAsString(), "File \"" + file.getPath() + "\" cannot be read, access denied.", e);
                }
            }
        }
        return true;
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public String getSyntax() {
        return "<file_1,...,file_n>";
    }

    public static enum FilesType {
        INPUT_FILES,
        OUTPUT_FILES;

    }
}

