/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.io.File;
import java.io.IOException;

public class FileParameter
extends AbstractParameter<FileParameter, File> {
    private FileType fileType;

    public FileParameter(OptionID optionID, FileType fileType) {
        super(optionID);
        this.fileType = fileType;
    }

    public FileParameter(OptionID optionID, FileType fileType, boolean optional) {
        this(optionID, fileType);
        this.setOptional(optional);
    }

    @Override
    public String getValueAsString() {
        try {
            return ((File)this.getValue()).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected File parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        if (obj instanceof String) {
            return new File((String)obj);
        }
        throw new WrongParameterValueException("Parameter \"" + this.getOptionID().getName() + "\": Unsupported value given!");
    }

    @Override
    protected boolean validate(File obj) throws ParameterException {
        if (!super.validate(obj)) {
            return false;
        }
        if (this.fileType.equals((Object)FileType.INPUT_FILE)) {
            try {
                if (obj.exists()) {
                    return true;
                }
                throw new WrongParameterValueException("Given file " + obj.getPath() + " for parameter \"" + this.getOptionID().getName() + "\" does not exist!\n");
            }
            catch (SecurityException e) {
                throw new WrongParameterValueException("Given file \"" + obj.getPath() + "\" cannot be read, access denied!\n" + e.getMessage());
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "<file>";
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public static enum FileType {
        INPUT_FILE,
        OUTPUT_FILE;

    }
}

