/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;

public class Flag
extends AbstractParameter<Flag, Boolean> {
    public static final String SET = "true";
    public static final String NOT_SET = "false";

    public Flag(OptionID optionID) {
        super(optionID);
        this.setOptional(true);
        this.setDefaultValue(Boolean.FALSE);
    }

    @Override
    protected Boolean parseValue(Object obj) throws ParameterException {
        if (SET.equals(obj)) {
            return Boolean.TRUE;
        }
        if (NOT_SET.equals(obj)) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj != null && SET.equals(obj.toString())) {
            return Boolean.TRUE;
        }
        if (obj != null && NOT_SET.equals(obj.toString())) {
            return Boolean.FALSE;
        }
        throw new WrongParameterValueException("Wrong value for flag \"" + this.getOptionID().getName() + "\". Allowed values:\n" + SET + " or " + NOT_SET);
    }

    @Override
    public String getSyntax() {
        return "<|true|false>";
    }

    @Override
    public String getValueAsString() {
        return (Boolean)this.getValue() != false ? SET : NOT_SET;
    }

    @Override
    protected boolean validate(Boolean obj) throws ParameterException {
        if (obj == null) {
            throw new WrongParameterValueException("Boolean option '" + this.getOptionID().getName() + "' got 'null' value.");
        }
        return true;
    }

    public void setValue(boolean val) {
        try {
            super.setValue(val);
        }
        catch (ParameterException e) {
            throw new AbortException("Flag did not accept boolean value!", e);
        }
    }

    public boolean isTrue() {
        return this.isDefined() && (Boolean)this.getValue() != false;
    }

    public boolean isFalse() {
        return this.isDefined() && (Boolean)this.getValue() == false;
    }
}

