/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.datastructures.range.IntGenerator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.range.ParseIntRanges;
import de.lmu.ifi.dbs.elki.utilities.datastructures.range.StaticIntGenerator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;

public class IntGeneratorParameter
extends AbstractParameter<IntGeneratorParameter, IntGenerator> {
    public IntGeneratorParameter(OptionID optionID, boolean optional) {
        super(optionID, optional);
    }

    public IntGeneratorParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((IntGenerator)this.getValue()).serializeTo(new StringBuilder(1000)).toString();
    }

    @Override
    public String getDefaultValueAsString() {
        return ((IntGenerator)this.getValue()).serializeTo(new StringBuilder(1000)).toString();
    }

    @Override
    protected IntGenerator parseValue(Object obj) throws ParameterException {
        if (obj instanceof int[]) {
            return new StaticIntGenerator((int[])obj);
        }
        if (obj instanceof IntGenerator) {
            return (IntGenerator)obj;
        }
        if (obj instanceof String && !((String)obj).isEmpty()) {
            try {
                return ParseIntRanges.parseIntRanges((String)obj);
            }
            catch (NumberFormatException e) {
                throw new WrongParameterValueException(this, obj.toString(), "not a valid range of integers", e);
            }
        }
        if (obj instanceof Integer) {
            return new StaticIntGenerator((Integer)obj);
        }
        throw new WrongParameterValueException(this, obj.toString(), "requires a range of integers!");
    }

    @Override
    public String getSyntax() {
        return "<start,+=increment,end,...,start,*=factor,end,int1,int2>";
    }
}

