/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;

public class IntListParameter
extends ListParameter<IntListParameter, int[]> {
    public IntListParameter(OptionID optionID, boolean optional) {
        super(optionID, optional);
    }

    public IntListParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        int[] val = (int[])this.getValue();
        if (val.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(val[0]);
        for (int i = 1; i < val.length; ++i) {
            buf.append(",");
            buf.append(val[i]);
        }
        return buf.toString();
    }

    @Override
    public String getDefaultValueAsString() {
        int[] val = (int[])this.getDefaultValue();
        if (val.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(val[0]);
        for (int i = 1; i < val.length; ++i) {
            buf.append(",");
            buf.append(val[i]);
        }
        return buf.toString();
    }

    @Override
    protected int[] parseValue(Object obj) throws ParameterException {
        if (obj instanceof int[]) {
            return (int[])obj;
        }
        if (obj instanceof String) {
            String[] values = SPLIT.split((String)obj);
            int[] intValue = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                intValue[i] = ParseUtil.parseIntBase10(values[i]);
            }
            return intValue;
        }
        if (obj instanceof Integer) {
            return new int[]{(Integer)obj};
        }
        throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a list of Integer values!");
    }

    @Override
    public int size() {
        return ((int[])this.getValue()).length;
    }

    @Override
    public String getSyntax() {
        return "<int_1,...,int_n>";
    }

    public long[] getValueAsBitSet() {
        int[] value = (int[])this.getValue();
        int maxd = 0;
        for (int d : value) {
            maxd = d > maxd ? d : maxd;
        }
        long[] dimensions = new long[(maxd >>> 6) + 1];
        for (int d : value) {
            int n = d >>> 6;
            dimensions[n] = dimensions[n] | 1L << (d & 0x3F);
        }
        return dimensions;
    }
}

