/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.NumberParameter;

public class IntParameter
extends NumberParameter<IntParameter, Integer> {
    public IntParameter(OptionID optionID, int defaultValue) {
        super(optionID, defaultValue);
    }

    public IntParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Integer)this.getValue()).toString();
    }

    @Override
    protected Integer parseValue(Object obj) throws ParameterException {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return ParseUtil.parseIntBase10(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires an integer value, read: " + obj + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<int>";
    }

    public int intValue() {
        return (Integer)this.getValue();
    }
}

