/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.NumberParameter;

public class LongParameter
extends NumberParameter<LongParameter, Long> {
    public LongParameter(OptionID optionID, long defaultValue) {
        super(optionID, defaultValue);
    }

    public LongParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Long)this.getValue()).toString();
    }

    @Override
    protected Long parseValue(Object obj) throws ParameterException {
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return ParseUtil.parseLongBase10(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a long value, read: " + obj + "!\n");
        }
    }

    @Override
    public String getSyntax() {
        return "<long>";
    }
}

