/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;

public class ObjectParameter<C>
extends ClassParameter<C> {
    private C instance;

    public ObjectParameter(OptionID optionID, Class<?> restrictionClass, Class<?> defaultValue) {
        super(optionID, restrictionClass, defaultValue);
    }

    public <T extends C> ObjectParameter(OptionID optionID, Class<?> restrictionClass, T defaultValue) {
        super(optionID, restrictionClass);
        this.instance = defaultValue;
    }

    public ObjectParameter(OptionID optionID, Class<?> restrictionClass, boolean optional) {
        super(optionID, restrictionClass, optional);
    }

    public ObjectParameter(OptionID optionID, Class<?> restrictionClass) {
        super(optionID, restrictionClass);
    }

    @Override
    protected Class<? extends C> parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (this.restrictionClass.isInstance(obj)) {
            return obj.getClass();
        }
        return super.parseValue(obj);
    }

    @Override
    public void setValue(Object obj) throws ParameterException {
        if (this.restrictionClass.isInstance(obj)) {
            this.instance = obj;
        }
        super.setValue(obj);
    }

    @Override
    public String getSyntax() {
        return "<class|object>";
    }

    @Override
    public C instantiateClass(Parameterization config) {
        return this.instance != null ? this.instance : (this.instance = super.instantiateClass(config));
    }
}

