/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PatternParameter
extends AbstractParameter<PatternParameter, Pattern> {
    public PatternParameter(OptionID optionID, Pattern defaultValue) {
        super(optionID, defaultValue);
    }

    public PatternParameter(OptionID optionID, String defaultValue) {
        super(optionID, Pattern.compile(defaultValue, 2));
    }

    public PatternParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return ((Pattern)this.getValue()).toString();
    }

    @Override
    protected Pattern parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof Pattern) {
            return (Pattern)obj;
        }
        if (obj instanceof String) {
            try {
                return Pattern.compile((String)obj, 2);
            }
            catch (PatternSyntaxException e) {
                throw new WrongParameterValueException("Given pattern \"" + obj + "\" for parameter \"" + this.getOptionID().getName() + "\" is no valid regular expression!");
            }
        }
        throw new WrongParameterValueException("Given pattern \"" + obj + "\" for parameter \"" + this.getOptionID().getName() + "\" is of unknown type!");
    }

    @Override
    public String getSyntax() {
        return "<pattern>";
    }
}

