/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

public class RandomParameter
extends AbstractParameter<RandomParameter, RandomFactory> {
    private static final String GLOBAL_RANDOM_STR = "global random";
    Long seed = null;

    public RandomParameter(OptionID optionID) {
        super(optionID, RandomFactory.DEFAULT);
    }

    public RandomParameter(OptionID optionID, RandomFactory defaultValue) {
        super(optionID, defaultValue != null ? defaultValue : RandomFactory.DEFAULT);
    }

    public RandomParameter(OptionID optionID, long seed) {
        super(optionID, true);
        this.seed = seed;
    }

    @Override
    public String getSyntax() {
        return "<long>";
    }

    @Override
    public void setValue(Object obj) throws ParameterException {
        if (obj == null || obj instanceof RandomFactory) {
            this.seed = null;
        } else if (obj instanceof Long) {
            this.seed = (Long)obj;
            obj = RandomFactory.get(this.seed);
        } else if (obj instanceof Number) {
            this.seed = ((Number)obj).longValue();
            obj = RandomFactory.get(this.seed);
        } else if (GLOBAL_RANDOM_STR.equals(obj) || "global".equals(obj)) {
            obj = RandomFactory.DEFAULT;
        } else {
            try {
                this.seed = Long.valueOf(obj.toString());
                obj = RandomFactory.get(this.seed);
            }
            catch (NumberFormatException e) {
                throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a long seed value or a random generator factory, read: " + obj + "!\n");
            }
        }
        super.setValue(obj);
    }

    @Override
    protected RandomFactory parseValue(Object obj) throws ParameterException {
        if (obj instanceof RandomFactory) {
            return (RandomFactory)obj;
        }
        if (obj instanceof Long) {
            return RandomFactory.get((Long)obj);
        }
        if (obj instanceof Number) {
            return RandomFactory.get(((Number)obj).longValue());
        }
        try {
            return RandomFactory.get(Long.valueOf(obj.toString()));
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new WrongParameterValueException("Wrong parameter format! Parameter \"" + this.getOptionID().getName() + "\" requires a long seed value or a random generator factory, read: " + obj + "!\n");
        }
    }

    @Override
    public String getValueAsString() {
        return this.seed != null ? this.seed.toString() : (this.defaultValue != null ? ((RandomFactory)this.defaultValue).toString() : "null");
    }

    @Override
    public String getDefaultValueAsString() {
        if (this.defaultValue == RandomFactory.DEFAULT) {
            return GLOBAL_RANDOM_STR;
        }
        return super.getDefaultValueAsString();
    }
}

