/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;

public class StringParameter
extends AbstractParameter<StringParameter, String> {
    public StringParameter(OptionID optionID, String defaultValue) {
        super(optionID, defaultValue);
    }

    public StringParameter(OptionID optionID) {
        super(optionID);
    }

    @Override
    public String getValueAsString() {
        return (String)this.getValue();
    }

    @Override
    protected String parseValue(Object obj) throws ParameterException {
        if (obj == null) {
            throw new UnspecifiedParameterException(this);
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new WrongParameterValueException("String parameter " + this.getOptionID().getName() + " is not a string.");
    }

    @Override
    public String getSyntax() {
        return "<string>";
    }
}

