/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.pairs;

import java.util.Comparator;

public class DoubleDoublePair
implements Comparable<DoubleDoublePair> {
    public double first;
    public double second;
    public static final Comparator<DoubleDoublePair> BYFIRST_COMPARATOR = new Comparator<DoubleDoublePair>(){

        @Override
        public int compare(DoubleDoublePair o1, DoubleDoublePair o2) {
            return Double.compare(o1.first, o2.first);
        }
    };
    public static final Comparator<DoubleDoublePair> BYSECOND_COMPARATOR = new Comparator<DoubleDoublePair>(){

        @Override
        public int compare(DoubleDoublePair o1, DoubleDoublePair o2) {
            return Double.compare(o1.second, o2.second);
        }
    };
    public static final Comparator<DoubleDoublePair> SWAPPED_COMPARATOR = new Comparator<DoubleDoublePair>(){

        @Override
        public int compare(DoubleDoublePair o1, DoubleDoublePair o2) {
            return o1.compareSwappedTo(o2);
        }
    };

    public DoubleDoublePair(double first, double second) {
        this.first = first;
        this.second = second;
    }

    public DoubleDoublePair(DoubleDoublePair other) {
        this(other.first, other.second);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleDoublePair other = (DoubleDoublePair)obj;
        return this.first == other.first && this.second == other.second;
    }

    public final int hashCode() {
        long firsthash = Double.doubleToLongBits(this.first);
        firsthash ^= firsthash >> 32;
        long secondhash = Double.doubleToLongBits(this.second);
        secondhash ^= secondhash >> 32;
        return (int)(firsthash * -1640531535L + secondhash);
    }

    @Override
    public int compareTo(DoubleDoublePair other) {
        int fdiff = Double.compare(this.first, other.first);
        if (fdiff != 0) {
            return fdiff;
        }
        return Double.compare(this.second, other.second);
    }

    public int compareSwappedTo(DoubleDoublePair other) {
        int fdiff = Double.compare(this.second, other.second);
        if (fdiff != 0) {
            return fdiff;
        }
        return Double.compare(this.first, other.first);
    }

    public final void setFirst(double first) {
        this.first = first;
    }

    public final void setSecond(double second) {
        this.second = second;
    }

    public String toString() {
        return "DoubleDoublePair(" + this.first + "," + this.second + ")";
    }
}

