/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.pairs;

import java.util.Comparator;

public class DoubleIntPair
implements Comparable<DoubleIntPair> {
    public double first;
    public int second;
    public static final Comparator<DoubleIntPair> BYFIRST_COMPARATOR = new Comparator<DoubleIntPair>(){

        @Override
        public int compare(DoubleIntPair o1, DoubleIntPair o2) {
            return Double.compare(o1.first, o2.first);
        }
    };
    public static final Comparator<DoubleIntPair> BYSECOND_COMPARATOR = new Comparator<DoubleIntPair>(){

        @Override
        public int compare(DoubleIntPair o1, DoubleIntPair o2) {
            return o1.second - o2.second;
        }
    };
    public static final Comparator<DoubleIntPair> SWAPPED_COMPARATOR = new Comparator<DoubleIntPair>(){

        @Override
        public int compare(DoubleIntPair o1, DoubleIntPair o2) {
            return o1.compareSwappedTo(o2);
        }
    };

    public DoubleIntPair(double first, int second) {
        this.first = first;
        this.second = second;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleIntPair other = (DoubleIntPair)obj;
        return this.first == other.first && this.second == other.second;
    }

    public final int hashCode() {
        long firsthash = Double.doubleToLongBits(this.first);
        firsthash ^= firsthash >> 32;
        return (int)(firsthash * -1640531535L + (long)this.second);
    }

    @Override
    public int compareTo(DoubleIntPair other) {
        int fdiff = Double.compare(this.first, other.first);
        if (fdiff != 0) {
            return fdiff;
        }
        return this.second - other.second;
    }

    public int compareSwappedTo(DoubleIntPair other) {
        int fdiff = this.second - other.second;
        if (fdiff != 0) {
            return fdiff;
        }
        return Double.compare(this.second, other.second);
    }

    public final void setFirst(double first) {
        this.first = first;
    }

    public final void setSecond(int second) {
        this.second = second;
    }
}

