/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.random;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

public class FastNonThreadsafeRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private long seed;
    protected static final String BADBOUND = "bound must be positive";

    public FastNonThreadsafeRandom() {
    }

    public FastNonThreadsafeRandom(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    public void setSeed(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    @Override
    protected int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - bits);
    }

    @Override
    public int nextInt() {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 16);
    }

    @Override
    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) * (double)1.110223E-16f;
    }

    @Override
    @Reference(authors="D. Lemire", title="Fast random shuffling", booktitle="Daniel Lemire's blog", url="http://lemire.me/blog/2016/06/30/fast-random-shuffling/", bibkey="blog/Lemire16")
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BADBOUND);
        }
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)((this.seed >>> 16) * (long)n >>> 32);
    }

    @Reference(authors="D. Lemire", title="Fast random shuffling", booktitle="Daniel Lemire's blog", url="http://lemire.me/blog/2016/06/30/fast-random-shuffling/", bibkey="blog/Lemire16")
    public int nextIntRefined(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BADBOUND);
        }
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        long ret = (this.seed >>> 16) * (long)n;
        int leftover = (int)(ret & Integer.MAX_VALUE);
        if (leftover < n) {
            long threshold = ((long)(-n) & 0xFFFFFFFFL) % (long)n;
            while ((long)leftover < threshold) {
                this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
                ret = (this.seed >>> 16) * (long)n;
                leftover = (int)(ret & Integer.MAX_VALUE);
            }
        }
        return (int)(ret >>> 32);
    }
}

