/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.random;

import de.lmu.ifi.dbs.elki.utilities.random.Xoroshiro128NonThreadsafeRandom;
import java.util.Random;

public class RandomFactory {
    public static RandomFactory DEFAULT = new RandomFactory(RandomFactory.getGlobalSeed()){

        @Override
        public String toString() {
            return "GlobalRandom[" + Long.toString(this.seed) + "]";
        }
    };
    protected long seed;

    private static long getGlobalSeed() {
        String sseed = System.getProperty("elki.seed");
        return sseed != null ? Long.parseLong(sseed) : System.nanoTime();
    }

    public static RandomFactory get(Long seed) {
        if (seed == null) {
            return DEFAULT;
        }
        return new RandomFactory(seed);
    }

    public RandomFactory(long seed) {
        this.seed = seed;
    }

    public Random getRandom() {
        return new Random(this.seed++);
    }

    public Random getSingleThreadedRandom() {
        return new Xoroshiro128NonThreadsafeRandom(this.seed++);
    }

    public String toString() {
        return "Random[" + Long.toString(this.seed) + "]";
    }
}

