/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.random;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="S. Vigna", title="An experimental exploration of Marsaglia's xorshift generators, scrambled", booktitle="Online", url="http://vigna.di.unimi.it/ftp/papers/xorshift.pdf", bibkey="web/Vigna14")
public class XorShift1024NonThreadsafeRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long[] x;
    int p = 0;
    protected static final String BADBOUND = "bound must be positive";

    public XorShift1024NonThreadsafeRandom() {
    }

    public XorShift1024NonThreadsafeRandom(long seed) {
        super(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.x = new long[16];
        long xor64 = seed != 0L ? seed : 4101842887655102017L;
        for (int i = 0; i < 16; ++i) {
            xor64 ^= xor64 >>> 12;
            xor64 ^= xor64 << 25;
            xor64 ^= xor64 >>> 27;
            this.x[i] = xor64 * 2685821657736338717L;
        }
    }

    @Override
    public long nextLong() {
        long s0 = this.x[this.p];
        this.p = this.p + 1 & 0xF;
        long s1 = this.x[this.p];
        s1 ^= s1 << 31;
        s1 ^= s1 >>> 11;
        s0 ^= s0 >>> 30;
        this.x[this.p] = s0 ^ s1;
        return this.x[this.p] * 1181783497276652981L;
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() >>> 64 - bits);
    }

    @Override
    public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    @Reference(authors="D. Lemire", title="Fast random shuffling", booktitle="Daniel Lemire's blog", url="http://lemire.me/blog/2016/06/30/fast-random-shuffling/", bibkey="blog/Lemire16")
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BADBOUND);
        }
        return (int)((this.nextLong() >>> 32) * (long)n >>> 32);
    }
}

