/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.random;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="D. Blackman, S. Vigna", title="xoroshiro+ / xorshift* / xorshift+ generators and the PRNG shootout", booktitle="Online", url="http://xoroshiro.di.unimi.it/", bibkey="web/BlackmanV16")
public class Xoroshiro128NonThreadsafeRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long s0;
    private long s1;
    static final String BADBOUND = "bound must be positive";

    public Xoroshiro128NonThreadsafeRandom() {
    }

    public Xoroshiro128NonThreadsafeRandom(long seed) {
        super(seed);
    }

    @Override
    public void setSeed(long seed) {
        long xor64 = seed != 0L ? seed : 4101842887655102017L;
        xor64 ^= xor64 >>> 12;
        xor64 ^= xor64 << 25;
        xor64 ^= xor64 >>> 27;
        this.s0 = xor64 * 2685821657736338717L;
        xor64 ^= xor64 >>> 12;
        xor64 ^= xor64 << 25;
        xor64 ^= xor64 >>> 27;
        this.s1 = xor64 * 2685821657736338717L;
    }

    @Override
    public long nextLong() {
        long t0 = this.s0;
        long t1 = this.s1;
        long result = t0 + t1;
        this.s0 = Long.rotateLeft(t0, 55) ^ (t1 ^= t0) ^ t1 << 14;
        this.s1 = Long.rotateLeft(t1, 36);
        return result;
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() >>> 64 - bits);
    }

    @Override
    public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    @Reference(authors="D. Lemire", title="Fast random shuffling", booktitle="Daniel Lemire's blog", url="http://lemire.me/blog/2016/06/30/fast-random-shuffling/", bibkey="blog/Lemire16")
    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BADBOUND);
        }
        long r = this.nextLong();
        r = (n & -n) == n ? (r &= (long)(n - 1)) : (r >>> 32) * (long)n >>> 32;
        return (int)r;
    }
}

