/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class AxisBasedReferencePoints
implements ReferencePointsHeuristic {
    protected double spacescale;

    public AxisBasedReferencePoints(double spacescale) {
        this.spacescale = spacescale;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> db) {
        int d;
        double[][] minmax = RelationUtil.computeMinMax(db);
        int dim = RelationUtil.dimensionality(db);
        double[] mean = minmax[0];
        double[] delta = minmax[1];
        for (int d2 = 0; d2 < dim; ++d2) {
            int n = d2;
            delta[n] = delta[n] - mean[d2];
            int n2 = d2;
            mean[n2] = mean[n2] - delta[d2] * 0.5;
        }
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>(2 + dim);
        double[] vec = new double[dim];
        for (d = 0; d < dim; ++d) {
            vec[d] = mean[d] - delta[d];
        }
        result.add(DoubleVector.copy(vec));
        for (d = 0; d < dim; ++d) {
            vec[d] = mean[d] + delta[d];
        }
        result.add(DoubleVector.copy(vec));
        for (int i = 0; i < dim; ++i) {
            for (int d3 = 0; d3 < dim; ++d3) {
                vec[d3] = d3 != i ? mean[d3] - delta[d3] : mean[d3] + delta[d3];
            }
            result.add(DoubleVector.copy(vec));
        }
        return result;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SPACE_SCALE_ID = new OptionID("axisref.scale", "Scale the data space extension by the given factor.");
        protected double spacescale = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter spacescaleP = (DoubleParameter)new DoubleParameter(SPACE_SCALE_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (config.grab(spacescaleP)) {
                this.spacescale = (Double)spacescaleP.getValue();
            }
        }

        @Override
        protected AxisBasedReferencePoints makeInstance() {
            return new AxisBasedReferencePoints(this.spacescale);
        }
    }
}

