/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class GridBasedReferencePoints
implements ReferencePointsHeuristic {
    private static final Logging LOG = Logging.getLogger(GridBasedReferencePoints.class);
    protected int gridres;
    protected double gridscale;

    public GridBasedReferencePoints(int gridres, double gridscale) {
        this.gridres = gridres;
        this.gridscale = gridscale;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> db) {
        double[][] minmax = RelationUtil.computeMinMax(db);
        int dim = minmax[0].length;
        double[] mean = new double[dim];
        for (int d = 0; d < dim; ++d) {
            mean[d] = (minmax[0][d] + minmax[1][d]) * 0.5;
        }
        if (this.gridres <= 0) {
            LOG.warning("Grid of resolution " + this.gridres + " will have a single point only.");
            ArrayList<DoubleVector> result = new ArrayList<DoubleVector>(1);
            result.add(DoubleVector.wrap(mean));
            return result;
        }
        int grids = this.gridres + 1;
        int gridpoints = MathUtil.ipowi(grids, dim);
        if (gridpoints < 0) {
            throw new AbortException("Grids with more than 2^31 are not supported, or meaningful.");
        }
        if (gridpoints > db.size()) {
            LOG.warning("Grid has " + gridpoints + " points, but you only have " + db.size() + " observations.");
        }
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>(gridpoints);
        double[] delta = new double[dim];
        for (int d = 0; d < dim; ++d) {
            delta[d] = (minmax[1][d] - minmax[0][d]) / (double)this.gridres;
        }
        double halfgrid = (double)this.gridres * 0.5;
        for (int i = 0; i < gridpoints; ++i) {
            double[] vec = new double[dim];
            int acc = i;
            for (int d = 0; d < dim; ++d) {
                int coord = acc % grids;
                acc /= grids;
                vec[d] = mean[d] + ((double)coord - halfgrid) * delta[d] * this.gridscale;
            }
            result.add(DoubleVector.wrap(vec));
        }
        return result;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID GRID_ID = new OptionID("grid.size", "The number of partitions in each dimension. Points will be placed on the edges of the grid, except for a grid size of 0, where only the mean is generated as reference point.");
        public static final OptionID GRID_SCALE_ID = new OptionID("grid.scale", "Scale the grid by the given factor. This can be used to obtain reference points outside the used data space.");
        protected int gridres;
        protected double gridscale;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter gridscaleP;
            super.makeOptions(config);
            IntParameter gridP = (IntParameter)new IntParameter(GRID_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(gridP)) {
                this.gridres = (Integer)gridP.getValue();
            }
            if (config.grab(gridscaleP = (DoubleParameter)new DoubleParameter(GRID_SCALE_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.gridscale = (Double)gridscaleP.getValue();
            }
        }

        @Override
        protected GridBasedReferencePoints makeInstance() {
            return new GridBasedReferencePoints(this.gridres, this.gridscale);
        }
    }
}

