/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public class RandomGeneratedReferencePoints
implements ReferencePointsHeuristic {
    protected int samplesize;
    protected double scale = 1.0;
    protected RandomFactory rnd;

    public RandomGeneratedReferencePoints(int samplesize, double scale, RandomFactory rnd) {
        this.samplesize = samplesize;
        this.scale = scale;
        this.rnd = rnd;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> db) {
        double[][] minmax = RelationUtil.computeMinMax(db);
        int dim = RelationUtil.dimensionality(db);
        double[] mean = minmax[0];
        double[] delta = minmax[1];
        for (int d = 0; d < dim; ++d) {
            int n = d;
            delta[n] = delta[n] - mean[d];
            int n2 = d;
            mean[n2] = mean[n2] - delta[d] * 0.5;
        }
        Random rand = this.rnd.getSingleThreadedRandom();
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>(this.samplesize);
        for (int i = 0; i < this.samplesize; ++i) {
            double[] vec = new double[dim];
            for (int d = 0; d < dim; ++d) {
                vec[d] = mean[d] + (rand.nextDouble() - 0.5) * this.scale * delta[d];
            }
            result.add(DoubleVector.wrap(vec));
        }
        return result;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID N_ID = new OptionID("generate.n", "The number of reference points to be generated.");
        public static final OptionID SCALE_ID = new OptionID("generate.scale", "Scale the grid by the given factor. This can be used to obtain reference points outside the used data space.");
        public static final OptionID RANDOM_ID = new OptionID("generate.random", "Random generator seed.");
        protected int samplesize;
        protected double scale = 1.0;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            DoubleParameter scaleP;
            super.makeOptions(config);
            IntParameter samplesizeP = (IntParameter)new IntParameter(N_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(samplesizeP)) {
                this.samplesize = (Integer)samplesizeP.getValue();
            }
            if (config.grab(scaleP = (DoubleParameter)new DoubleParameter(SCALE_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.scale = (Double)scaleP.getValue();
            }
            if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                this.rnd = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected RandomGeneratedReferencePoints makeInstance() {
            return new RandomGeneratedReferencePoints(this.samplesize, this.scale, this.rnd);
        }
    }
}

