/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class RandomSampleReferencePoints
implements ReferencePointsHeuristic {
    protected int samplesize;
    protected RandomFactory rnd;

    public RandomSampleReferencePoints(int samplesize, RandomFactory rnd) {
        this.samplesize = samplesize;
        this.rnd = rnd;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> db) {
        if (this.samplesize >= db.size()) {
            LoggingUtil.warning("Requested sample size is larger than database size!");
            return new RelationUtil.CollectionFromRelation<NumberVector>(db);
        }
        ModifiableDBIDs sample = DBIDUtil.randomSample(db.getDBIDs(), this.samplesize, this.rnd);
        ArrayList<NumberVector> result = new ArrayList<NumberVector>(sample.size());
        DBIDIter it = sample.iter();
        while (it.valid()) {
            result.add(db.get(it));
            it.advance();
        }
        return result;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID N_ID = new OptionID("sample.n", "The number of samples to draw.");
        public static final OptionID RANDOM_ID = new OptionID("sample.random", "Random generator seed.");
        protected int samplesize;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter randomP;
            super.makeOptions(config);
            IntParameter samplesizeP = (IntParameter)new IntParameter(N_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(samplesizeP)) {
                this.samplesize = samplesizeP.intValue();
            }
            if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                this.rnd = (RandomFactory)randomP.getValue();
            }
        }

        @Override
        protected RandomSampleReferencePoints makeInstance() {
            return new RandomSampleReferencePoints(this.samplesize, this.rnd);
        }
    }
}

