/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.referencepoints;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.ArrayList;
import java.util.Collection;

public class StarBasedReferencePoints
implements ReferencePointsHeuristic {
    protected boolean nocenter;
    protected double scale;

    public StarBasedReferencePoints(boolean nocenter, double scale) {
        this.nocenter = nocenter;
        this.scale = scale;
    }

    @Override
    public Collection<? extends NumberVector> getReferencePoints(Relation<? extends NumberVector> db) {
        int dim = RelationUtil.dimensionality(db);
        double[] centroid = new double[dim];
        double[] min = new double[dim];
        double[] max = new double[dim];
        for (int d = 0; d < dim; ++d) {
            centroid[d] = 0.0;
            min[d] = Double.MAX_VALUE;
            max[d] = -1.7976931348623157E308;
        }
        DBIDIter iditer = db.iterDBIDs();
        while (iditer.valid()) {
            NumberVector obj = db.get(iditer);
            for (int d = 0; d < dim; ++d) {
                double val = obj.doubleValue(d);
                int n = d;
                centroid[n] = centroid[n] + val;
                min[d] = Math.min(min[d], val);
                max[d] = Math.max(max[d], val);
            }
            iditer.advance();
        }
        for (int d = 0; d < dim; ++d) {
            centroid[d] = centroid[d] / (double)db.size();
            min[d] = (min[d] - centroid[d]) * this.scale + centroid[d];
            max[d] = (max[d] - centroid[d]) * this.scale + centroid[d];
        }
        ArrayList<DoubleVector> result = new ArrayList<DoubleVector>(2 * dim + 1);
        if (!this.nocenter) {
            result.add(DoubleVector.wrap(centroid));
        }
        for (int i = 0; i < dim; ++i) {
            double[] vec = (double[])centroid.clone();
            vec[i] = min[i];
            result.add(DoubleVector.wrap(vec));
            vec = (double[])centroid.clone();
            vec[i] = max[i];
            result.add(DoubleVector.wrap(vec));
        }
        return result;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NOCENTER_ID = new OptionID("star.nocenter", "Do not use the center as extra reference point.");
        public static final OptionID SCALE_ID = new OptionID("star.scale", "Scale the reference points by the given factor. This can be used to obtain reference points outside the used data space.");
        protected boolean nocenter;
        protected double scale;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter scaleP;
            super.makeOptions(config);
            Flag nocenterF = new Flag(NOCENTER_ID);
            if (config.grab(nocenterF)) {
                this.nocenter = (Boolean)nocenterF.getValue();
            }
            if (config.grab(scaleP = (DoubleParameter)new DoubleParameter(SCALE_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                this.scale = (Double)scaleP.getValue();
            }
        }

        @Override
        protected StarBasedReferencePoints makeInstance() {
            return new StarBasedReferencePoints(this.nocenter, this.scale);
        }
    }
}

