/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;

public class ClipScaling
implements StaticScalingFunction {
    public static final OptionID MIN_ID = new OptionID("clipscale.min", "Minimum value to allow.");
    public static final OptionID MAX_ID = new OptionID("clipscale.max", "Maximum value to allow.");
    private Double min = null;
    private Double max = null;

    public ClipScaling(Double min, Double max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public double getScaled(double value) {
        if (this.min != null && value < this.min) {
            return this.min;
        }
        if (this.max != null && value > this.max) {
            return this.max;
        }
        return value;
    }

    @Override
    public double getMin() {
        return this.min != null ? this.min : Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMax() {
        return this.max != null ? this.max : Double.POSITIVE_INFINITY;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected Double min = null;
        protected Double max = null;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter maxP;
            super.makeOptions(config);
            DoubleParameter minP = (DoubleParameter)new DoubleParameter(MIN_ID).setOptional(true);
            if (config.grab(minP)) {
                this.min = (Double)minP.getValue();
            }
            if (config.grab(maxP = (DoubleParameter)new DoubleParameter(MAX_ID).setOptional(true))) {
                this.max = (Double)maxP.getValue();
            }
        }

        @Override
        protected ClipScaling makeInstance() {
            return new ClipScaling(this.min, this.max);
        }
    }
}

