/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;
import net.jafama.FastMath;

public class GammaScaling
implements StaticScalingFunction {
    private double gamma;

    public GammaScaling() {
        this(1.0);
    }

    public GammaScaling(double gamma) {
        this.gamma = gamma;
    }

    @Override
    public double getScaled(double d) {
        return FastMath.pow(d, this.gamma);
    }

    @Override
    public double getMin() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMax() {
        return Double.POSITIVE_INFINITY;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID GAMMA_ID = new OptionID("scaling.gamma", "Gamma value for scaling.");
        double gamma = 1.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter gammaP = new DoubleParameter(GAMMA_ID);
            if (config.grab(gammaP)) {
                this.gamma = (Double)gammaP.getValue();
            }
        }

        @Override
        protected GammaScaling makeInstance() {
            return new GammaScaling(this.gamma);
        }
    }
}

