/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.utilities.scaling.StaticScalingFunction;

public class LinearScaling
implements StaticScalingFunction {
    private double factor;
    private double shift;

    public LinearScaling() {
        this(1.0, 0.0);
    }

    public LinearScaling(double factor) {
        this(factor, 0.0);
    }

    public LinearScaling(double factor, double shift) {
        this.factor = factor;
        this.shift = shift;
    }

    public LinearScaling(DoubleMinMax minmax) {
        this.factor = 1.0 / (minmax.getMax() - minmax.getMin());
        this.shift = -minmax.getMin() * this.factor;
    }

    @Override
    public double getScaled(double d) {
        return this.factor * d + this.shift;
    }

    @Override
    public double getMin() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMax() {
        return Double.POSITIVE_INFINITY;
    }

    public static LinearScaling fromMinMax(double min, double max) {
        double zoom = 1.0 / (max - min);
        return new LinearScaling(zoom, -min * zoom);
    }
}

