/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.meta.BestFitEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.Arrays;

@References(value={@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE Int. Conf. on Data Mining (ICDM 2012)", url="https://doi.org/10.1109/ICDM.2012.21", bibkey="DBLP:conf/icdm/KriegelKSZ12"), @Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")})
public class COPOutlierScaling
implements OutlierScaling {
    private double phi = 0.0;
    private Distribution dist;
    private boolean inverted = false;

    public COPOutlierScaling(double phi) {
        this.phi = phi;
    }

    @Override
    public double getScaled(double value) {
        if (this.dist == null) {
            throw new AbortException("Programming error: outlier scaling not initialized.");
        }
        double s = this.inverted ? 1.0 - this.dist.cdf(value) : this.dist.cdf(value);
        return this.phi > 0.0 ? this.phi * s / (1.0 - s + this.phi) : s;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public void prepare(OutlierResult or) {
        DoubleRelation scores = or.getScores();
        double[] s = new double[scores.size()];
        int i = 0;
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            s[i] = scores.doubleValue(id);
            id.advance();
            ++i;
        }
        Arrays.sort(s);
        this.dist = BestFitEstimator.STATIC.estimate(s, ArrayLikeUtil.DOUBLEARRAYADAPTER);
        this.inverted = or.getOutlierMeta() instanceof InvertedOutlierScoreMeta;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        double[] s = ArrayLikeUtil.toPrimitiveDoubleArray(array, adapter);
        Arrays.sort(s);
        this.dist = BestFitEstimator.STATIC.estimate(s, ArrayLikeUtil.DOUBLEARRAYADAPTER);
        this.inverted = false;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID PHI_ID = new OptionID("copscaling.phi", "Phi parameter, expected rate of outliers. Set to 0 to use raw CDF values.");
        private double phi = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter phiP = new DoubleParameter(PHI_ID);
            if (config.grab(phiP)) {
                this.phi = phiP.doubleValue();
            }
        }

        @Override
        protected COPOutlierScaling makeInstance() {
            return new COPOutlierScaling(this.phi);
        }
    }
}

