/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.Arrays;
import net.jafama.FastMath;

public class LogRankingPseudoOutlierScaling
implements OutlierScaling {
    private double[] scores;
    private boolean inverted = false;

    @Override
    public void prepare(OutlierResult or) {
        DoubleRelation oscores = or.getScores();
        this.scores = new double[oscores.size()];
        int pos = 0;
        if (or.getOutlierMeta() instanceof InvertedOutlierScoreMeta) {
            this.inverted = true;
        }
        DBIDIter iditer = oscores.iterDBIDs();
        while (iditer.valid()) {
            this.scores[pos] = oscores.doubleValue(iditer);
            ++pos;
            iditer.advance();
        }
        if (pos != oscores.size()) {
            throw new AbortException("Database size is incorrect!");
        }
        Arrays.sort(this.scores);
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        this.scores = ArrayLikeUtil.toPrimitiveDoubleArray(array, adapter);
        Arrays.sort(this.scores);
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double value) {
        assert (this.scores != null) : "prepare() was not run prior to using the scaling function.";
        int pos = Arrays.binarySearch(this.scores, value);
        if (this.inverted) {
            return FastMath.log1p(1.0 - (double)pos / ((double)this.scores.length - 1.0));
        }
        return FastMath.log1p((double)pos / ((double)this.scores.length - 1.0));
    }
}

