/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierGammaScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class MinusLogGammaScaling
extends OutlierGammaScaling {
    double max = 0.0;
    double mlogmax;

    public MinusLogGammaScaling() {
        super(false);
    }

    @Override
    protected double preScale(double score) {
        assert (this.max > 0.0) : "prepare() was not run prior to using the scaling function.";
        return -FastMath.log(score / this.max) / this.mlogmax;
    }

    @Override
    public void prepare(OutlierResult or) {
        this.meta = or.getOutlierMeta();
        DoubleMinMax mm = new DoubleMinMax();
        DoubleRelation scores = or.getScores();
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            double score = scores.doubleValue(id);
            if (!Double.isNaN(score) && !Double.isInfinite(score)) {
                mm.put(score);
            }
            id.advance();
        }
        this.max = mm.getMax();
        this.mlogmax = -FastMath.log(mm.getMin() / this.max);
        MeanVariance mv = new MeanVariance();
        DBIDIter id2 = scores.iterDBIDs();
        while (id2.valid()) {
            double score = this.preScale(scores.doubleValue(id2));
            if (!Double.isNaN(score) && !Double.isInfinite(score)) {
                mv.put(score);
            }
            id2.advance();
        }
        double mean = mv.getMean();
        double var = mv.getSampleVariance();
        this.k = mean * mean / var;
        this.theta = var / mean;
        this.atmean = GammaDistribution.regularizedGammaP(this.k, mean / this.theta);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected MinusLogGammaScaling makeInstance() {
            return new MinusLogGammaScaling();
        }
    }
}

