/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.StandardDeviationScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class MinusLogStandardDeviationScaling
extends StandardDeviationScaling {
    public MinusLogStandardDeviationScaling(double fixedmean, double lambda) {
        super(fixedmean, lambda);
    }

    @Override
    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        double mlogv = -FastMath.log(value);
        return mlogv < this.mean || Double.isNaN(mlogv) ? 0.0 : Math.max(0.0, NormalDistribution.erf((mlogv - this.mean) / this.factor));
    }

    @Override
    public void prepare(OutlierResult or) {
        if (Double.isNaN(this.fixedmean)) {
            MeanVariance mv = new MeanVariance();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = -FastMath.log(scores.doubleValue(id));
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    mv.put(val);
                }
                id.advance();
            }
            this.mean = mv.getMean();
            this.factor = this.lambda * mv.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.fixedmean;
            Mean sqsum = new Mean();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = -FastMath.log(scores.doubleValue(id));
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    sqsum.put((val - this.mean) * (val - this.mean));
                }
                id.advance();
            }
            this.factor = this.lambda * FastMath.sqrt(sqsum.getMean()) * MathUtil.SQRT2;
        }
    }

    public static class Parameterizer
    extends StandardDeviationScaling.Parameterizer {
        @Override
        protected MinusLogStandardDeviationScaling makeInstance() {
            return new MinusLogStandardDeviationScaling(this.fixedmean, this.lambda);
        }
    }
}

