/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import net.jafama.FastMath;

@Reference(authors="J. Gao, P.-N. Tan", title="Converting Output Scores from Outlier Detection Algorithms into Probability Estimates", booktitle="Proc. Sixth International Conference on Data Mining, 2006. ICDM'06.", url="https://doi.org/10.1109/ICDM.2006.43", bibkey="DBLP:conf/icdm/GaoT06")
@Alias(value={"de.lmu.ifi.dbs.elki.utilities.scaling.outlier.MixtureModelOutlierScalingFunction"})
public class MixtureModelOutlierScaling
implements OutlierScaling {
    private static final Logging LOG = Logging.getLogger(MixtureModelOutlierScaling.class);
    protected double mu;
    protected double sigma;
    protected double lambda;
    protected double alpha;
    public static final double ONEBYSQRT2PI = 1.0 / MathUtil.SQRTTWOPI;
    private static final double DELTA = 1.0E-4;

    protected static double calcP_i(double f, double mu, double sigma) {
        double fmu = f - mu;
        return ONEBYSQRT2PI / sigma * FastMath.exp(fmu * fmu / (-2.0 * sigma * sigma));
    }

    protected static double calcQ_i(double f, double lambda) {
        return lambda * FastMath.exp(-lambda * f);
    }

    protected static double calcPosterior(double f, double alpha, double mu, double sigma, double lambda) {
        double pi = MixtureModelOutlierScaling.calcP_i(f, mu, sigma);
        double qi = MixtureModelOutlierScaling.calcQ_i(f, lambda);
        return alpha * pi / (alpha * pi + (1.0 - alpha) * qi);
    }

    @Override
    public void prepare(OutlierResult or) {
        double curAlpha;
        double curLambda;
        double curSigma;
        double curMu;
        block7: {
            MeanVariance mv = new MeanVariance();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id);
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    mv.put(val);
                }
                id.advance();
            }
            curMu = mv.getMean() * 2.0;
            if (curMu == 0.0) {
                curMu = Double.MIN_NORMAL;
            }
            curSigma = Math.max(mv.getSampleStddev(), Double.MIN_NORMAL);
            curLambda = Math.min(1.0 / curMu, Double.MAX_VALUE);
            curAlpha = 0.05;
            DBIDs ids = scores.getDBIDs();
            int iter = 0;
            do {
                double otisum = 0.0;
                double itisum = 0.0;
                double owsum = 0.0;
                double iwsum = 0.0;
                double osqsum = 0.0;
                DBIDIter it = ids.iter();
                while (it.valid()) {
                    double val = scores.doubleValue(it);
                    double ti = MixtureModelOutlierScaling.calcPosterior(val, curAlpha, curMu, curSigma, curLambda);
                    otisum += ti;
                    itisum += 1.0 - ti;
                    owsum += ti * val;
                    iwsum += (1.0 - ti) * val;
                    osqsum += ti * val * val;
                    it.advance();
                }
                if (otisum <= 0.0 || owsum <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block7;
                }
                double newMu = owsum / otisum;
                double newSigma = Math.max(FastMath.sqrt(osqsum / otisum - newMu * newMu), Double.MIN_NORMAL);
                double newLambda = Math.min(itisum / iwsum, Double.MAX_VALUE);
                double newAlpha = otisum / (double)ids.size();
                if (Math.abs(newMu - curMu) < 1.0E-4 && Math.abs(newSigma - curSigma) < 1.0E-4 && Math.abs(newLambda - curLambda) < 1.0E-4 && Math.abs(newAlpha - curAlpha) < 1.0E-4) break block7;
                if (newSigma <= 0.0 || newAlpha <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block7;
                }
                curMu = newMu;
                curSigma = newSigma;
                curLambda = newLambda;
                curAlpha = newAlpha;
            } while (++iter <= 100);
            LOG.warning("Max iterations met in mixture model fitting.");
        }
        this.mu = curMu;
        this.sigma = curSigma;
        this.lambda = curLambda;
        this.alpha = curAlpha;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        double curAlpha;
        double curLambda;
        double curSigma;
        double curMu;
        block6: {
            MeanVariance mv = new MeanVariance();
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (Double.isNaN(val) || Double.isInfinite(val)) continue;
                mv.put(val);
            }
            curMu = mv.getMean() * 2.0;
            if (curMu == 0.0) {
                curMu = Double.MIN_NORMAL;
            }
            curSigma = Math.max(mv.getSampleStddev(), Double.MIN_NORMAL);
            curLambda = Math.min(1.0 / curMu, Double.MAX_VALUE);
            curAlpha = 0.05;
            int iter = 0;
            do {
                double otisum = 0.0;
                double itisum = 0.0;
                double owsum = 0.0;
                double iwsum = 0.0;
                double osqsum = 0.0;
                for (int i = 0; i < size; ++i) {
                    double val = adapter.getDouble(array, i);
                    double ti = MixtureModelOutlierScaling.calcPosterior(val, curAlpha, curMu, curSigma, curLambda);
                    otisum += ti;
                    itisum += 1.0 - ti;
                    owsum += ti * val;
                    iwsum += (1.0 - ti) * val;
                    osqsum += ti * val * val;
                }
                if (otisum <= 0.0 || owsum <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block6;
                }
                double newMu = owsum / otisum;
                double newSigma = Math.max(FastMath.sqrt(osqsum / otisum - newMu * newMu), Double.MIN_NORMAL);
                double newLambda = Math.min(itisum / iwsum, Double.MAX_VALUE);
                double newAlpha = otisum / (double)size;
                if (Math.abs(newMu - curMu) < 1.0E-4 && Math.abs(newSigma - curSigma) < 1.0E-4 && Math.abs(newLambda - curLambda) < 1.0E-4 && Math.abs(newAlpha - curAlpha) < 1.0E-4) break block6;
                if (newSigma <= 0.0 || newAlpha <= 0.0) {
                    LOG.warning("MixtureModel Outlier Scaling converged to extreme.");
                    break block6;
                }
                curMu = newMu;
                curSigma = newSigma;
                curLambda = newLambda;
                curAlpha = newAlpha;
            } while (++iter <= 100);
            LOG.warning("Max iterations met in mixture model fitting.");
        }
        this.mu = curMu;
        this.sigma = curSigma;
        this.lambda = curLambda;
        this.alpha = curAlpha;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double value) {
        double val = MixtureModelOutlierScaling.calcPosterior(value, this.alpha, this.mu, this.sigma, this.lambda);
        return val > 0.0 ? val : 0.0;
    }
}

