/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class MultiplicativeInverseScaling
implements OutlierScaling {
    double scaleval = 0.0;

    @Override
    public double getScaled(double value) {
        assert (this.scaleval != 0.0) : "prepare() was not run prior to using the scaling function.";
        try {
            return 1.0 / (value * this.scaleval);
        }
        catch (ArithmeticException e) {
            return 1.0;
        }
    }

    @Override
    public void prepare(OutlierResult or) {
        double max = Double.MIN_VALUE;
        DoubleRelation scores = or.getScores();
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            double val = scores.doubleValue(id);
            double inv = Math.abs(1.0 / val);
            if (!Double.isInfinite(inv) && !Double.isNaN(inv)) {
                max = Math.max(max, inv);
            }
            id.advance();
        }
        this.scaleval = max;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        double max = Double.MIN_VALUE;
        int size = adapter.size(array);
        for (int i = 0; i < size; ++i) {
            double inv = Math.abs(1.0 / adapter.getDouble(array, i));
            if (Double.isInfinite(inv) || Double.isNaN(inv)) continue;
            max = Math.max(max, inv);
        }
        this.scaleval = max;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }
}

