/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;

public class OutlierLinearScaling
implements OutlierScaling {
    protected Double min = null;
    protected Double max = null;
    double factor;
    boolean usemean = false;
    boolean nozeros = false;

    public OutlierLinearScaling() {
        this(null, null, false, false);
    }

    public OutlierLinearScaling(Double min, Double max, boolean usemean, boolean nozeros) {
        this.min = min;
        this.max = max;
        this.usemean = usemean;
        this.nozeros = nozeros;
        if (min != null && max != null) {
            this.factor = max - min;
        }
    }

    @Override
    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        if (value <= this.min) {
            return 0.0;
        }
        return Math.min(1.0, (value - this.min) / this.factor);
    }

    @Override
    public void prepare(OutlierResult or) {
        if (this.min == null || this.max == null || this.usemean) {
            double mi = Double.MAX_VALUE;
            double ma = Double.MIN_VALUE;
            double sum = 0.0;
            int count = 0;
            int skippedzeros = 0;
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id);
                if (this.nozeros && val == 0.0) {
                    ++skippedzeros;
                } else {
                    sum += val;
                    ++count;
                    mi = val < mi ? val : mi;
                    ma = val > ma ? val : ma;
                }
                id.advance();
            }
            if (count == 0 && skippedzeros > 0) {
                ma = 0.0;
                mi = 0.0;
                sum = 0.0;
            }
            this.min = this.usemean && count > 0 ? sum / (double)count : (this.min != null ? this.min : mi);
            this.max = this.max != null ? this.max : ma;
        }
        this.factor = this.max > this.min ? this.max - this.min : 1.0;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        if (this.min == null || this.max == null || this.usemean) {
            double mi = Double.MAX_VALUE;
            double ma = Double.MIN_VALUE;
            double sum = 0.0;
            int count = 0;
            int skippedzeros = 0;
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (this.nozeros && val == 0.0) {
                    ++skippedzeros;
                    continue;
                }
                sum += val;
                ++count;
                mi = val < mi ? val : mi;
                ma = val > ma ? val : ma;
            }
            if (count == 0 && skippedzeros > 0) {
                ma = 0.0;
                mi = 0.0;
                sum = 0.0;
            }
            this.min = this.usemean && count > 0 ? sum / (double)count : (this.min != null ? this.min : mi);
            this.max = this.max != null ? this.max : ma;
        }
        this.factor = this.max > this.min ? this.max - this.min : 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MIN_ID = new OptionID("linearscale.min", "Fixed minimum to use in linear scaling.");
        public static final OptionID MAX_ID = new OptionID("linearscale.max", "Fixed maximum to use in linear scaling.");
        public static final OptionID MEAN_ID = new OptionID("linearscale.usemean", "Use the mean as minimum for scaling.");
        public static final OptionID NOZEROS_ID = new OptionID("linearscale.ignorezero", "Ignore zero entries when computing the minimum and maximum.");
        protected Double min = null;
        protected Double max = null;
        boolean usemean = false;
        boolean nozeros = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag nozerosF;
            Flag meanF;
            DoubleParameter maxP;
            super.makeOptions(config);
            DoubleParameter minP = (DoubleParameter)new DoubleParameter(MIN_ID).setOptional(true);
            if (config.grab(minP)) {
                this.min = (Double)minP.getValue();
            }
            if (config.grab(maxP = (DoubleParameter)new DoubleParameter(MAX_ID).setOptional(true))) {
                this.max = (Double)maxP.getValue();
            }
            if (!minP.isDefined() && !maxP.isDefined() && config.grab(meanF = new Flag(MEAN_ID))) {
                this.usemean = (Boolean)meanF.getValue();
            }
            if (config.grab(nozerosF = new Flag(NOZEROS_ID))) {
                this.nozeros = (Boolean)nozerosF.getValue();
            }
        }

        @Override
        protected OutlierLinearScaling makeInstance() {
            return new OutlierLinearScaling(this.min, this.max, this.usemean, this.nozeros);
        }
    }
}

