/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class OutlierMinusLogScaling
implements OutlierScaling {
    double max = 0.0;
    double mlogmax;

    @Override
    public double getScaled(double value) {
        assert (this.max != 0.0) : "prepare() was not run prior to using the scaling function.";
        return -FastMath.log(value / this.max) / this.mlogmax;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public void prepare(OutlierResult or) {
        DoubleMinMax mm = new DoubleMinMax();
        DoubleRelation scores = or.getScores();
        DBIDIter id = scores.iterDBIDs();
        while (id.valid()) {
            double val = scores.doubleValue(id);
            if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                mm.put(val);
            }
            id.advance();
        }
        this.max = mm.getMax();
        this.mlogmax = -FastMath.log(mm.getMin() / this.max);
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        DoubleMinMax mm = new DoubleMinMax();
        int size = adapter.size(array);
        for (int i = 0; i < size; ++i) {
            double val = adapter.getDouble(array, i);
            if (Double.isNaN(val) || Double.isInfinite(val)) continue;
            mm.put(val);
        }
        this.max = mm.getMax();
        this.mlogmax = -FastMath.log(mm.getMin() / this.max);
    }
}

