/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import net.jafama.FastMath;

public class OutlierSqrtScaling
implements OutlierScaling {
    protected double min;
    protected double max;
    protected Double pmin = null;
    protected Double pmax = null;
    protected double factor;

    public OutlierSqrtScaling(Double pmin, Double pmax) {
        this.pmin = pmin;
        this.pmax = pmax;
    }

    @Override
    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        return value <= this.min ? 0.0 : Math.min(1.0, FastMath.sqrt(value - this.min) / this.factor);
    }

    @Override
    public void prepare(OutlierResult or) {
        if (this.pmin == null || this.pmax == null) {
            DoubleMinMax mm = new DoubleMinMax();
            DoubleRelation scores = or.getScores();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id);
                if (!Double.isInfinite(val)) {
                    mm.put(val);
                }
                id.advance();
            }
            this.min = this.pmin == null ? mm.getMin() : this.pmin.doubleValue();
            this.max = this.pmax == null ? mm.getMax() : this.pmax.doubleValue();
        }
        this.factor = FastMath.sqrt(this.max - this.min);
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        if (this.pmin == null || this.pmax == null) {
            DoubleMinMax mm = new DoubleMinMax();
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (Double.isInfinite(val)) continue;
                mm.put(val);
            }
            this.min = this.pmin == null ? mm.getMin() : this.pmin.doubleValue();
            this.max = this.pmax == null ? mm.getMax() : this.pmax.doubleValue();
        }
        this.factor = FastMath.sqrt(this.max - this.min);
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MIN_ID = new OptionID("sqrtscale.min", "Fixed minimum to use in sqrt scaling.");
        public static final OptionID MAX_ID = new OptionID("sqrtscale.max", "Fixed maximum to use in sqrt scaling.");
        protected double min;
        protected double max;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter maxP;
            super.makeOptions(config);
            DoubleParameter minP = (DoubleParameter)new DoubleParameter(MIN_ID).setOptional(true);
            if (config.grab(minP)) {
                this.min = (Double)minP.getValue();
            }
            if (config.grab(maxP = (DoubleParameter)new DoubleParameter(MAX_ID).setOptional(true))) {
                this.max = (Double)maxP.getValue();
            }
        }

        @Override
        protected OutlierSqrtScaling makeInstance() {
            return new OutlierSqrtScaling(this.min, this.max);
        }
    }
}

