/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.Arrays;

public class RankingPseudoOutlierScaling
implements OutlierScaling {
    private double[] scores;
    private boolean inverted = false;

    @Override
    public void prepare(OutlierResult or) {
        DoubleRelation oscores = or.getScores();
        this.scores = new double[oscores.size()];
        if (or.getOutlierMeta() instanceof InvertedOutlierScoreMeta) {
            this.inverted = true;
        }
        int pos = 0;
        DBIDIter iditer = oscores.iterDBIDs();
        while (iditer.valid()) {
            this.scores[pos++] = oscores.doubleValue(iditer);
            iditer.advance();
        }
        if (pos != oscores.size()) {
            throw new AbortException("Database size is incorrect!");
        }
        Arrays.sort(this.scores);
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        this.scores = ArrayLikeUtil.toPrimitiveDoubleArray(array, adapter);
        Arrays.sort(this.scores);
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getScaled(double value) {
        int first;
        int pos;
        assert (this.scores != null) : "prepare() was not run prior to using the scaling function.";
        int last = pos;
        for (first = pos = Arrays.binarySearch(this.scores, value); first > 0 && this.scores[first - 1] == value; --first) {
        }
        while (last + 1 < this.scores.length && this.scores[last + 1] == value) {
            ++last;
        }
        double v = (double)(first + last) * 0.5 / ((double)this.scores.length - 1.0);
        return this.inverted ? 1.0 - v : v;
    }
}

