/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class SqrtStandardDeviationScaling
implements OutlierScaling {
    double min;
    double mean;
    double factor;
    double pmin = Double.NaN;
    double pmean = Double.NaN;
    double plambda;

    public SqrtStandardDeviationScaling(double pmin, double pmean, double plambda) {
        this.pmin = pmin;
        this.pmean = pmean;
        this.plambda = plambda;
    }

    @Override
    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        return value <= this.mean ? 0.0 : Math.max(0.0, NormalDistribution.erf((FastMath.sqrt(value - this.min) - this.mean) / this.factor));
    }

    @Override
    public void prepare(OutlierResult or) {
        DoubleRelation scores = or.getScores();
        if (Double.isNaN(this.pmean)) {
            MeanVarianceMinMax mv = new MeanVarianceMinMax();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id);
                mv.put(val <= this.min ? 0.0 : FastMath.sqrt(val - this.min));
                id.advance();
            }
            this.min = Double.isNaN(this.pmin) ? mv.getMin() : this.pmin;
            this.mean = mv.getMean();
            this.factor = this.plambda * mv.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.pmean;
            double sqsum = 0.0;
            double mm = Double.POSITIVE_INFINITY;
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id);
                mm = Math.min(mm, val);
                val = (val <= this.min ? 0.0 : FastMath.sqrt(val - this.min)) - this.mean;
                sqsum += val * val;
                id.advance();
            }
            this.min = Double.isNaN(this.pmin) ? mm : this.pmin;
            this.factor = this.plambda * FastMath.sqrt(sqsum / (double)scores.size()) * MathUtil.SQRT2;
        }
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        if (Double.isNaN(this.pmean)) {
            MeanVarianceMinMax mv = new MeanVarianceMinMax();
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                mv.put(val <= this.min ? 0.0 : FastMath.sqrt(val - this.min));
            }
            this.min = Double.isNaN(this.pmin) ? mv.getMin() : this.pmin;
            this.mean = mv.getMean();
            this.factor = this.plambda * mv.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.pmean;
            double sqsum = 0.0;
            double mm = Double.POSITIVE_INFINITY;
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                mm = Math.min(mm, val);
                val = (val <= this.min ? 0.0 : FastMath.sqrt(val - this.min)) - this.mean;
                sqsum += val * val;
            }
            this.min = Double.isNaN(this.pmin) ? mm : this.pmin;
            this.factor = this.plambda * FastMath.sqrt(sqsum / (double)size) * MathUtil.SQRT2;
        }
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MIN_ID = new OptionID("sqrtstddevscale.min", "Fixed minimum to use in sqrt scaling.");
        public static final OptionID MEAN_ID = new OptionID("sqrtstddevscale.mean", "Fixed mean to use in standard deviation scaling.");
        public static final OptionID LAMBDA_ID = new OptionID("sqrtstddevscale.lambda", "Significance level to use for error function.");
        double min = Double.NaN;
        double mean = Double.NaN;
        protected double lambda;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter lambdaP;
            DoubleParameter meanP;
            super.makeOptions(config);
            DoubleParameter minP = (DoubleParameter)new DoubleParameter(MIN_ID).setOptional(true);
            if (config.grab(minP)) {
                this.min = minP.doubleValue();
            }
            if (config.grab(meanP = (DoubleParameter)new DoubleParameter(MEAN_ID).setOptional(true))) {
                this.mean = meanP.doubleValue();
            }
            if (config.grab(lambdaP = new DoubleParameter(LAMBDA_ID, 3.0))) {
                this.lambda = lambdaP.doubleValue();
            }
        }

        @Override
        protected SqrtStandardDeviationScaling makeInstance() {
            return new SqrtStandardDeviationScaling(this.min, this.mean, this.lambda);
        }
    }
}

