/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import net.jafama.FastMath;

@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM 2011)", url="https://doi.org/10.1137/1.9781611972818.2", bibkey="DBLP:conf/sdm/KriegelKSZ11")
public class StandardDeviationScaling
implements OutlierScaling {
    protected double fixedmean = Double.NaN;
    protected double lambda;
    double mean;
    double factor;

    public StandardDeviationScaling(double fixedmean, double lambda) {
        this.fixedmean = fixedmean;
        this.lambda = lambda;
    }

    public StandardDeviationScaling() {
        this(Double.NaN, 1.0);
    }

    @Override
    public double getScaled(double value) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        return value <= this.mean ? 0.0 : Math.max(0.0, NormalDistribution.erf((value - this.mean) / this.factor));
    }

    @Override
    public void prepare(OutlierResult or) {
        DoubleRelation scores = or.getScores();
        if (Double.isNaN(this.fixedmean)) {
            MeanVariance mv = new MeanVariance();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id);
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    mv.put(val);
                }
                id.advance();
            }
            this.mean = mv.getMean();
            this.factor = this.lambda * mv.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.fixedmean;
            Mean sqsum = new Mean();
            DBIDIter id = scores.iterDBIDs();
            while (id.valid()) {
                double val = scores.doubleValue(id) - this.mean;
                if (!Double.isNaN(val) && !Double.isInfinite(val)) {
                    sqsum.put(val * val);
                }
                id.advance();
            }
            this.factor = this.lambda * FastMath.sqrt(sqsum.getMean()) * MathUtil.SQRT2;
        }
        this.factor = this.factor > 0.0 ? this.factor : Double.MIN_NORMAL;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        if (Double.isNaN(this.fixedmean)) {
            MeanVariance mv = new MeanVariance();
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (Double.isInfinite(val)) continue;
                mv.put(val);
            }
            this.mean = mv.getMean();
            this.factor = this.lambda * mv.getSampleStddev() * MathUtil.SQRT2;
        } else {
            this.mean = this.fixedmean;
            Mean sqsum = new Mean();
            int size = adapter.size(array);
            for (int i = 0; i < size; ++i) {
                double val = adapter.getDouble(array, i);
                if (Double.isInfinite(val)) continue;
                sqsum.put((val - this.mean) * (val - this.mean));
            }
            this.factor = this.lambda * FastMath.sqrt(sqsum.getMean()) * MathUtil.SQRT2;
        }
        this.factor = this.factor > 0.0 ? this.factor : Double.MIN_NORMAL;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MEAN_ID = new OptionID("stddevscale.mean", "Fixed mean to use in standard deviation scaling.");
        public static final OptionID LAMBDA_ID = new OptionID("stddevscale.lambda", "Significance level to use for error function.");
        protected double fixedmean = Double.NaN;
        protected double lambda;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter lambdaP;
            super.makeOptions(config);
            DoubleParameter meanP = (DoubleParameter)new DoubleParameter(MEAN_ID).setOptional(true);
            if (config.grab(meanP)) {
                this.fixedmean = (Double)meanP.getValue();
            }
            if (config.grab(lambdaP = new DoubleParameter(LAMBDA_ID, 3.0))) {
                this.lambda = (Double)lambdaP.getValue();
            }
        }

        @Override
        protected StandardDeviationScaling makeInstance() {
            return new StandardDeviationScaling(this.fixedmean, this.lambda);
        }
    }
}

