/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayLikeUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;

public class TopKOutlierScaling
implements OutlierScaling {
    private int k = -1;
    private boolean binary = false;
    private double cutoff;
    private double ground;
    private double max;

    public TopKOutlierScaling(int k, boolean binary) {
        this.k = k;
        this.binary = binary;
    }

    @Override
    public void prepare(OutlierResult or) {
        OrderingResult ordering = or.getOrdering();
        DBIDs ids = ordering.getDBIDs();
        this.cutoff = or.getScores().doubleValue(ordering.order(ids).iter().seek(Math.min(this.k, ids.size()) - 1));
        this.max = or.getOutlierMeta().getActualMaximum();
        this.ground = or.getOutlierMeta().getTheoreticalBaseline();
        this.ground = Double.isInfinite(this.ground) || Double.isNaN(this.ground) ? or.getOutlierMeta().getTheoreticalMinimum() : this.ground;
        this.ground = Double.isInfinite(this.ground) || Double.isNaN(this.ground) ? or.getOutlierMeta().getActualMinimum() : this.ground;
    }

    @Override
    public <A> void prepare(A array, NumberArrayAdapter<?, A> adapter) {
        double[] scores = ArrayLikeUtil.toPrimitiveDoubleArray(array, adapter);
        this.cutoff = QuickSelect.quickSelect(scores, this.k - 1);
        this.max = Double.NEGATIVE_INFINITY;
        for (double v : scores) {
            this.max = Math.max(this.max, v);
        }
        this.ground = Math.min(0.0, this.cutoff);
    }

    @Override
    public double getMax() {
        return this.binary ? 1.0 : this.max;
    }

    @Override
    public double getMin() {
        return this.binary ? 0.0 : this.ground;
    }

    @Override
    public double getScaled(double value) {
        return this.binary ? (value >= this.cutoff ? 1.0 : 0.0) : (value >= this.cutoff ? (value - this.ground) / (this.max - this.ground) : 0.0);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("topk.k", "Number of outliers to keep.");
        public static final OptionID BINARY_ID = new OptionID("topk.binary", "Make the top k a binary scaling.");
        private int k = -1;
        private boolean binary = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag binaryF;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(binaryF = new Flag(BINARY_ID))) {
                this.binary = binaryF.isTrue();
            }
        }

        @Override
        protected TopKOutlierScaling makeInstance() {
            return new TopKOutlierScaling(this.k, this.binary);
        }
    }
}

