/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;

public class VisualizationTask
implements VisualizationItem,
Comparable<VisualizationTask> {
    private int level = 0;
    private boolean visible = true;
    private int flags;
    private int updatemask;
    private boolean tool = false;
    public static final int LEVEL_BACKGROUND = 0;
    public static final int LEVEL_DATA = 100;
    public static final int LEVEL_STATIC = 200;
    public static final int LEVEL_FOREGROUND = 300;
    public static final int LEVEL_INTERACTIVE = 1000;
    private String name;
    private VisFactory factory;
    private Object result;
    private Relation<?> relation;
    private double reqwidth = 1.0;
    private double reqheight = 1.0;

    public VisualizationTask(VisFactory factory, String name, Object result, Relation<?> relation) {
        this.name = name;
        this.result = result;
        this.relation = relation;
        this.factory = factory;
    }

    public VisualizationTask with(UpdateFlag f) {
        this.updatemask |= f.bit;
        return this;
    }

    public boolean has(UpdateFlag f) {
        return (this.updatemask & f.bit) != 0;
    }

    public VisualizationTask with(RenderFlag f) {
        this.flags |= f.bit;
        return this;
    }

    public boolean has(RenderFlag f) {
        return (this.flags & f.bit) != 0;
    }

    public VisualizationTask level(int level) {
        this.level = level;
        return this;
    }

    public int level() {
        return this.level;
    }

    public VisualizationTask tool(boolean t) {
        this.tool = t;
        return this;
    }

    public boolean isTool() {
        return this.tool;
    }

    public VisualizationTask visibility(boolean vis) {
        this.visible = vis;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public VisualizationTask requestSize(double w, double h) {
        this.reqwidth = w;
        this.reqheight = h;
        return this;
    }

    public double getRequestedWidth() {
        return this.reqwidth;
    }

    public double getRequestedHeight() {
        return this.reqheight;
    }

    public VisFactory getFactory() {
        return this.factory;
    }

    public <R> R getResult() {
        return (R)this.result;
    }

    public <R extends Relation<?>> R getRelation() {
        return (R)this.relation;
    }

    @Override
    public String getMenuName() {
        return this.name;
    }

    @Override
    public int compareTo(VisualizationTask other) {
        if (this.level != other.level) {
            return this.level - other.level;
        }
        String name1 = this.getMenuName();
        String name2 = other.getMenuName();
        if (name1 != null && name2 != null && name1 != name2) {
            return name1.compareTo(name2);
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("VisTask: ").append(this.factory.getClass().getName()).append(' ');
        if (this.result != null && this.result instanceof Result) {
            buf.append("Result: ").append(((Result)this.result).getLongName()).append(' ');
        }
        buf.append(super.toString());
        return buf.toString();
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public static enum UpdateFlag {
        ON_DATA(1),
        ON_SELECTION(2),
        ON_STYLEPOLICY(4),
        ON_SAMPLE(8);

        final int bit;

        private UpdateFlag(int bit) {
            this.bit = bit;
        }
    }

    public static enum RenderFlag {
        NO_THUMBNAIL(1),
        NO_DETAIL(2),
        NO_EXPORT(4),
        NO_EMBED(8);

        final int bit;

        private RenderFlag(int bit) {
            this.bit = bit;
        }
    }
}

