/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.HashMapHierarchy;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.StackedIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.EmptyIterator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import java.util.ArrayList;
import java.util.function.BiConsumer;

public class VisualizationTree
extends HashMapHierarchy<Object> {
    private ArrayList<VisualizationListener> vlistenerList = new ArrayList();

    public void addVisualizationListener(VisualizationListener listener) {
        for (int i = 0; i < this.vlistenerList.size(); ++i) {
            if (this.vlistenerList.get(i) != listener) continue;
            return;
        }
        this.vlistenerList.add(listener);
    }

    public void removeVisualizationListener(VisualizationListener listener) {
        this.vlistenerList.remove(listener);
    }

    public void visChanged(VisualizationItem item) {
        int i = this.vlistenerList.size();
        while (--i >= 0) {
            VisualizationListener listener = this.vlistenerList.get(i);
            if (listener == null) continue;
            listener.visualizationChanged(item);
        }
    }

    public static It<Object> findVis(VisualizerContext context) {
        return new StackedIter(context.getHierarchy().iterAll(), context.getVisHierarchy());
    }

    public static It<Object> findVis(VisualizerContext context, Object start) {
        if (start instanceof Result) {
            It<Result> it1 = context.getHierarchy().iterDescendantsSelf((Result)start);
            return new StackedIter<Object, Result>(it1, context.getVisHierarchy());
        }
        return context.getVisHierarchy().iterDescendantsSelf(start);
    }

    public static It<Result> findNewResults(VisualizerContext context, Object start) {
        return start instanceof Result ? context.getHierarchy().iterDescendantsSelf((Result)start) : EmptyIterator.empty();
    }

    public static <A extends Result, B extends VisualizationItem> void findNewSiblings(VisualizerContext context, Object start, Class<? super A> type1, Class<? super B> type2, BiConsumer<A, B> handler) {
        ResultHierarchy hier = context.getHierarchy();
        VisualizationTree vistree = context.getVisHierarchy();
        if (start instanceof Result) {
            It<A> it1 = hier.iterDescendantsSelf((Result)start).filter(type1);
            while (it1.valid()) {
                Result result = (Result)it1.get();
                It<B> it2 = vistree.iterDescendantsSelf(context.getBaseResult()).filter(type2);
                while (it2.valid()) {
                    handler.accept(result, it2.get());
                    it2.advance();
                }
                it1.advance();
            }
        }
        It<B> it2 = vistree.iterDescendantsSelf(start).filter(type2);
        while (it2.valid()) {
            VisualizationItem vis = (VisualizationItem)it2.get();
            It<A> it1 = hier.iterAll().filter(type1);
            while (it1.valid()) {
                handler.accept(it1.get(), vis);
                it1.advance();
            }
            it2.advance();
        }
    }

    public static <A extends Result, B extends VisualizationItem> void findNewResultVis(VisualizerContext context, Object start, Class<? super A> type1, Class<? super B> type2, BiConsumer<A, B> handler) {
        It<Result> it3;
        VisualizationTree hier = context.getVisHierarchy();
        if (start instanceof Result) {
            It<A> it1 = context.getHierarchy().iterDescendantsSelf((Result)start).filter(type1);
            while (it1.valid()) {
                Result result = (Result)it1.get();
                it3 = context.getHierarchy().iterDescendantsSelf(result);
                while (it3.valid()) {
                    It<B> it2 = hier.iterDescendantsSelf(it3.get()).filter(type2);
                    while (it2.valid()) {
                        handler.accept(result, it2.get());
                        it2.advance();
                    }
                    it3.advance();
                }
                it1.advance();
            }
        }
        if (start instanceof VisualizationItem) {
            It<B> it2 = hier.iterDescendantsSelf(start).filter(type2);
            while (it2.valid()) {
                VisualizationItem vis = (VisualizationItem)it2.get();
                it3 = hier.iterAncestorsSelf(vis).filter(Result.class);
                while (it3.valid()) {
                    It<A> it1 = context.getHierarchy().iterAncestorsSelf(it3.get()).filter(type1);
                    while (it1.valid()) {
                        handler.accept(it1.get(), vis);
                        it1.advance();
                    }
                    it3.advance();
                }
                it2.advance();
            }
        }
    }

    public static void setVisible(VisualizerContext context, VisualizationTask task, boolean visibility) {
        if (visibility && task.isTool()) {
            VisualizationTree vistree = context.getVisHierarchy();
            It<VisualizationTask> iter2 = vistree.iterAll().filter(VisualizationTask.class);
            while (iter2.valid()) {
                VisualizationTask other = iter2.get();
                if (other != task && other.isTool() && other.isVisible()) {
                    context.visChanged(other.visibility(false));
                }
                iter2.advance();
            }
        }
        context.visChanged(task.visibility(visibility));
    }
}

