/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelHierarchicalClustering;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.TrivialAllInOne;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.evaluation.AutomaticEvaluation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationProcessor;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VisualizerContext
implements DataStoreListener,
Result {
    private static final Logging LOG = Logging.getLogger(VisualizerContext.class);
    private VisualizationTree vistree = new VisualizationTree();
    private ResultHierarchy hier;
    private ArrayList<DataStoreListener> listenerList = new ArrayList();
    private Collection<VisualizationProcessor> factories;
    private SelectionResult selection;
    StylingPolicy stylepolicy;
    StyleLibrary stylelibrary;
    private Result baseResult;

    public VisualizerContext(ResultHierarchy hier, Result start, StyleLibrary stylelib, Collection<VisualizationProcessor> factories) {
        this.hier = hier;
        this.baseResult = start;
        this.factories = factories;
        Database db = ResultUtil.findDatabase(hier);
        if (db == null) {
            LOG.warning("No database reachable from " + hier);
            return;
        }
        AutomaticEvaluation.ensureClusteringResult(db, db);
        this.selection = SelectionResult.ensureSelectionResult(db);
        for (Relation<?> rel : ResultUtil.getRelations(db)) {
            SamplingResult.getSamplingResult(rel);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(rel.getDataTypeInformation())) continue;
            Relation<?> vrel = rel;
            ScalesResult.getScalesResult(vrel);
        }
        this.makeStyleResult(stylelib);
        this.notifyFactories(db);
        db.addDataStoreListener(this);
        this.addResultListener(new ResultListener(){

            @Override
            public void resultAdded(Result child, Result parent) {
                VisualizerContext.this.notifyFactories(child);
            }

            @Override
            public void resultChanged(Result current) {
            }

            @Override
            public void resultRemoved(Result child, Result parent) {
            }
        });
    }

    protected void makeStyleResult(StyleLibrary stylelib) {
        Database db = ResultUtil.findDatabase(this.hier);
        this.stylelibrary = stylelib;
        List<Clustering<Model>> clusterings = Clustering.getClusteringResults(db);
        if (!clusterings.isEmpty()) {
            this.stylepolicy = new ClusterStylingPolicy(clusterings.get(0), stylelib);
        } else {
            Clustering<Model> c = this.generateDefaultClustering();
            this.stylepolicy = new ClusterStylingPolicy(c, stylelib);
        }
    }

    public ResultHierarchy getHierarchy() {
        return this.hier;
    }

    public StylingPolicy getStylingPolicy() {
        return this.stylepolicy;
    }

    public void setStylingPolicy(StylingPolicy policy) {
        this.stylepolicy = policy;
        this.visChanged(policy);
    }

    public StyleLibrary getStyleLibrary() {
        return this.stylelibrary;
    }

    public void setStyleLibrary(StyleLibrary library) {
        this.stylelibrary = library;
    }

    private Clustering<Model> generateDefaultClustering() {
        Database db = ResultUtil.findDatabase(this.hier);
        Result c = null;
        try {
            ByLabelHierarchicalClustering split = new ByLabelHierarchicalClustering();
            c = split.run(db);
        }
        catch (NoSupportedDataTypeException e) {
            c = (Clustering)new TrivialAllInOne().run(db);
        }
        return c;
    }

    public SelectionResult getSelectionResult() {
        return this.selection;
    }

    public DBIDSelection getSelection() {
        return this.selection.getSelection();
    }

    public void setSelection(DBIDSelection sel) {
        this.selection.setSelection(sel);
        this.getHierarchy().resultChanged(this.selection);
    }

    public void addDataStoreListener(DataStoreListener l) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (this.listenerList.get(i) != l) continue;
            return;
        }
        this.listenerList.add(l);
    }

    public void removeDataStoreListener(DataStoreListener l) {
        this.listenerList.remove(l);
    }

    @Override
    public void contentChanged(DataStoreEvent e) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).contentChanged(e);
        }
    }

    public void addResultListener(ResultListener listener) {
        this.getHierarchy().addResultListener(listener);
    }

    public void removeResultListener(ResultListener listener) {
        this.getHierarchy().removeResultListener(listener);
    }

    public void addVisualizationListener(VisualizationListener listener) {
        this.vistree.addVisualizationListener(listener);
    }

    public void removeVisualizationListener(VisualizationListener listener) {
        this.vistree.removeVisualizationListener(listener);
    }

    @Override
    public String getLongName() {
        return "Visualizer context";
    }

    @Override
    public String getShortName() {
        return "vis-context";
    }

    public Result getBaseResult() {
        return this.baseResult;
    }

    public void addVis(Object parent, VisualizationItem vis) {
        this.vistree.add(parent, vis);
        this.notifyFactories(vis);
        this.visChanged(vis);
    }

    public void visChanged(VisualizationItem item) {
        this.vistree.visChanged(item);
    }

    private void notifyFactories(Object item) {
        for (VisualizationProcessor f : this.factories) {
            try {
                f.processNewResult(this, item);
            }
            catch (Throwable e) {
                LOG.warning("VisFactory " + f.getClass().getCanonicalName() + " failed:", e);
            }
        }
    }

    public List<VisualizationTask> getVisTasks(VisualizationItem item) {
        ArrayList<VisualizationTask> out = new ArrayList<VisualizationTask>();
        this.vistree.iterDescendants(item).filter(VisualizationTask.class).forEach(out::add);
        return out;
    }

    public VisualizationTree getVisHierarchy() {
        return this.vistree;
    }
}

